/***************************************************************************
                          ksteakplugin.cpp  -  description
                             -------------------
    begin                : Don Apr 26 13:08:29 CEST 2001
    copyright            : (C) 2001 by Olaf Hartig
    email                : OleBowle@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <khtml_part.h> // this plugin applies to a khtml part
#include <kdebug.h>
#include "ksteakplugin.h"
#include <kaction.h>
#include <kinstance.h>
#include <kiconloader.h>
#include <qmessagebox.h>
#include <klocale.h>
#include <dcopclient.h>
#include <qarray.h>
#include <kapp.h>
 
KSteakPlugin::KSteakPlugin( QObject* parent, const char* name )
    : Plugin( parent, name )
{
    (void) new KAction( "Translate via K&Steak",
                        "ksteakplugin", 0,
                        this, SLOT(slotAction()),
                        actionCollection(), "ksteakplugin" );
}
 
KSteakPlugin::~KSteakPlugin()
{
}
 

void KSteakPlugin::slotAction()
{
	QString szSelection;

	if ( ! parent()->inherits("KHTMLPart") )
	{
		QString title = i18n( "KSteakPlugin" );
		QString text = i18n( "The KSteak plugin can only be used for web pages, sorry." );
 
		QMessageBox::warning( 0, title, text );
	}
	else
	{
		KHTMLPart *part = static_cast<KHTMLPart *> (parent());
		szSelection = part->selectedText();

		if ( ! szSelection.isEmpty() )
		{
			DCOPClient * pClient = kapp->dcopClient();
			if ( ! pClient->attach() )
				kdDebug() << "Couldn't attach DCOP-Client" << endl;
			else
			{
				QByteArray data;
				QDataStream arg(data, IO_WriteOnly);

				arg << szSelection;

				if ( pClient->send( "ksteak", "KSteakIface","translate(QString)",data) )
					kdDebug() << "DCOP-message sent" << endl;
				else
					kdDebug() << "Couldn't send DCOP-message" << endl;
			}
		}
	}
}

KPluginFactory::KPluginFactory( QObject* parent, const char* name )
  : KLibFactory( parent, name )
{
  s_instance = new KInstance("KPluginFactory");
}
 
QObject* KPluginFactory::createObject( QObject* parent, const char* name, const char*, const QStringList & )
{
    QObject *obj = new KSteakPlugin( parent, name );
    return obj;
}
KPluginFactory::~KPluginFactory()
{ delete s_instance; }

 
extern "C"
{
  void* init_libksteakplugin()
  {
    return new KPluginFactory;
  }
 
}
 
KInstance* KPluginFactory::s_instance = 0L;
