/***************************************************************************
                          zoomdlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2004 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef ZOOMDLG_H
#define ZOOMDLG_H

#include <kdialogbase.h>

class KplSpinBox;

/**
  * Zoom dialog. Provides a dialog to enter magnification factor.
  * @author Werner Stille
  */
class ZoomDlg : public KDialogBase
{
  Q_OBJECT
public:
  /**
   * Constructor.
   * @param parent parent widget.
   * @param f magnification factor in percent.
   */
  ZoomDlg(QWidget* parent, int* f);
  /** Destructor. */
  ~ZoomDlg();

protected slots:
  /** Accepts factor and leaves the dialog. */
  virtual void slotOk();

protected:
  int* f;
  KplSpinBox* sb;
};

#endif
