/***************************************************************************
                          legenddlg.h  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qlineedit.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <klocale.h>
#include <kapp.h>
#include <kcolorbtn.h>
#include "kplspinbox.h"
#include "legenddlg.h"
#include "legenditem.h"
#include "kpldoc.h"
#include "edittextdlg.h"
#include "symboldlg.h"
#include "kpldoubleedit.h"

LegendDlg::LegendDlg(QWidget* _parent, KplDoc* model, LegendItem* ld0) :
 KDialogBase(Plain, i18n("Legend"), Help | Ok | Apply | Cancel, Ok, _parent),
 m(model), ld(ld0)
{
  QFrame* frame = plainPage();
  QVBoxLayout* vbox = new QVBoxLayout(frame, 0, spacingHint());
  QGroupBox* g = new QGroupBox(0, Qt::Vertical, i18n("Data"), frame);
  vbox->addWidget(g);
  QGridLayout* grid = new QGridLayout(g->layout(), 3, 7, spacingHint());
  grid->addWidget(new QLabel(i18n("Symbol"), g), 0, 0);
  grid->addWidget(symb = new KplSpinBox(-17, 9, 1, g), 0, 1);
  symb->setValue(ld->symb);
  SymbolButton *bSymb = new SymbolButton(g, symb);
  grid->addWidget(bSymb, 0, 2);
  bSymb->setFixedWidth(50);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 0, 3);
  grid->addWidget(new QLabel(i18n("Size"), g), 1, 0);
  grid->addWidget(eSymbSize = new KplSpinBox(10, 800, 1, g), 1, 1);
  eSymbSize->setValue(qRound(100 * ld->symbSize));
  eSymbSize->setSuffix(" %");
  grid->addWidget(new QLabel(i18n("Color"), g), 1, 4);
  grid->addWidget(colSymb = new KColorButton(ld->color, g), 1, 5);
  grid->addWidget(new QLabel("x", g), 2, 0);
  grid->addWidget(ex0 = new KplDoubleEdit(ld->x0, -200.0, 200.0, g), 2, 1);
  grid->addWidget(new QLabel("cm", g), 2, 2);
  grid->addWidget(new QLabel("y", g), 2, 4);
  grid->addWidget(ey0 = new KplDoubleEdit(ld->y0, -200.0, 200.0, g), 2, 5);
  grid->addWidget(new QLabel("cm", g), 2, 6);
  vbox->addWidget(g = new QGroupBox(0, Qt::Vertical, i18n("Label"), frame));
  grid = new QGridLayout(g->layout(), 3, 7, spacingHint());
  grid->addWidget(new QLabel(i18n("Text"), g), 0, 0);
  grid->addMultiCellWidget(eText = new QLineEdit(ld->s, g), 0, 0, 1, 5);
  QPushButton* b = new QPushButton("...", g);
  b->setFixedWidth(28);
  grid->addWidget(b, 0, 6);
  connect(b, SIGNAL(clicked()), SLOT(slotEditText()));
  grid->addWidget(new QLabel(i18n("Size"), g), 1, 0);
  grid->addWidget(eRelSize = new KplSpinBox(10, 800, 1, g), 1, 1);
  eRelSize->setValue(qRound(100 * ld->relsiz));
  eRelSize->setSuffix(" %");
  grid->addWidget(new QLabel(i18n("Color"), g), 1, 4);
  grid->addWidget(colText = new KColorButton(ld->coltext, g), 1, 5);
  grid->addWidget(new QLabel("xoff", g), 2, 0);
  grid->addWidget(exl = new KplDoubleEdit(ld->xtext, -200.0, 200.0, g), 2, 1);
  grid->addWidget(new QLabel("cm", g), 2, 2);
  grid->addItem(new QSpacerItem(20, 10, QSizePolicy::MinimumExpanding), 2, 3);
  grid->addWidget(new QLabel("yoff", g), 2, 4);
  grid->addWidget(eyl = new KplDoubleEdit(ld->ytext, -200.0, 200.0, g), 2, 5);
  grid->addWidget(new QLabel("cm", g), 2, 6);
#if KDE_VERSION == 303
  connect(this, SIGNAL(helpClicked()), SLOT(slotHelp2()));
#else
  setHelp("SEC-LEGEND");
#endif
  resize(minimumSize());
}

LegendDlg::~LegendDlg()
{
}

void LegendDlg::getValues(bool ok)
{
  ld->setPos(ex0->value(), ey0->value());
  ld->xtext = exl->value();
  ld->ytext = eyl->value();
  ld->color = colSymb->color().rgb();
  ld->coltext = colText->color().rgb();
  ld->symb = symb->interpretedValue();
  ld->symbSize = 0.01 * eSymbSize->interpretedValue();
  ld->relsiz = 0.01 * eRelSize->interpretedValue();
  ld->s = eText->text();
  m->setModified();
  m->backupItems();
  if (ok)
    accept();
}

void LegendDlg::slotEditText()
{
  EditTextDlg dlg(this, eText);
  dlg.exec();
}

void LegendDlg::slotOk()
{
  getValues(true);
}

void LegendDlg::slotApply()
{
  getValues(false);
}

void LegendDlg::slotHelp2()
{
#if KDE_VERSION == 303
  kapp->startServiceByDesktopName("konqueror", QString("help:/kpl/legend.html"),
                                  0, 0, 0, "", true);
#endif
}
