/***************************************************************************
                          edittextdlg.cpp  -  description
                             -------------------

    This file is a part of kpl - a program for graphical presentation of
    data sets and functions.

    begin                : Sun Apr 25 1999
    copyright            : (C) 2002 by Werner Stille
    email                : stille@uni-freiburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qpushbutton.h>
#include <qlineedit.h>
#include <qbuttongroup.h>
#include <qradiobutton.h>
#include <qlayout.h>
#include <klocale.h>
#include <kapp.h>
#include "edittextdlg.h"

Preview::Preview(QWidget* _parent) : QWidget(_parent), str(" ")
{
  QWidget::setBackgroundMode(PaletteBase);
}

Preview::~Preview()
{
}

void Preview::setText(const QString& s)
{
  str = s;
  update();
}

void Preview::paintEvent(QPaintEvent*)
{
  plInit(this, 0, 0);
  setRelSize(2.0);
  text(str, 10, 20, 1);
  end();
}

EditTextDlg::EditTextDlg(QWidget* _parent, QLineEdit* e) :
 KDialog(_parent, 0, true), sfont("#NN"), ed(e)
{
  setCaption(i18n("Edit text"));
  QVBoxLayout* vbox = new QVBoxLayout(this, marginHint(), spacingHint());
  vbox->addWidget(editPreview = new Preview(this));
  editPreview->setMinimumHeight(40);
  editPreview->setText(ed->text());
  QGridLayout* grid = new QGridLayout(vbox, 2, 2);
  grid->addWidget(text = new QLineEdit(ed->text(), this), 0, 0);
  text->setCursorPosition(strlen(ed->text()));
  connect(text, SIGNAL(textChanged(const QString&)),
          editPreview, SLOT(setText(const QString&)));
  QHBoxLayout* hbox = new QHBoxLayout(spacingHint());
  grid->addLayout(hbox, 0, 1);
  QPushButton* b = new QPushButton("<", this);
  hbox->addWidget(b);
  b->setFixedWidth(28);
  connect(b, SIGNAL(clicked()), SLOT(slotCat()));
  hbox->addWidget(font = new QLineEdit(sfont, this));
  font->setFixedWidth(60);
  grid->addWidget(bg1 = new QButtonGroup(6, Qt::Vertical, i18n("Font"), this),
                  1, 0);
  QRadioButton* r = new QRadioButton("Helvetica", bg1);
  connect(r, SIGNAL(clicked()), SLOT(slotFont()));
  r->setChecked(true);
  r = new QRadioButton("Helvetica Bold", bg1);
  connect(r, SIGNAL(clicked()), SLOT(slotFont()));
  r = new QRadioButton("Helvetica Italic", bg1);
  connect(r, SIGNAL(clicked()), SLOT(slotFont()));
  r = new QRadioButton("Helvetica Bold Italic", bg1);
  connect(r, SIGNAL(clicked()), SLOT(slotFont()));
  r = new QRadioButton("Symbol", bg1);
  connect(r, SIGNAL(clicked()), SLOT(slotFont()));
  r = new QRadioButton("ZapfDingbats", bg1);
  connect(r, SIGNAL(clicked()), SLOT(slotFont()));
  grid->addLayout(vbox = new QVBoxLayout(spacingHint()), 1, 1);
  vbox->addWidget(bg2 = new QButtonGroup(3, Qt::Vertical,
                                         i18n("Position"), this));
  r = new QRadioButton(i18n("Up"), bg2);
  connect(r, SIGNAL(clicked()), SLOT(slotPos()));
  r = new QRadioButton(i18n("Normal"), bg2);
  connect(r, SIGNAL(clicked()), SLOT(slotPos()));
  r->setChecked(true);
  r = new QRadioButton(i18n("Down"), bg2);
  connect(r, SIGNAL(clicked()), SLOT(slotPos()));
  vbox->addWidget(help = new QPushButton(i18n("&Help"), this));
  connect(help, SIGNAL(clicked()), SLOT(slotHelp()));
  vbox->addWidget(b = new QPushButton(i18n("&OK"), this));
  b->setDefault(true);
  b->setFocus();
  connect(b, SIGNAL(clicked()), SLOT(slotOk()));
  vbox->addWidget(b = new QPushButton(i18n("&Cancel"), this));
  connect(b, SIGNAL(clicked()), SLOT(reject()));
}

EditTextDlg::~EditTextDlg()
{
}

void EditTextDlg::editText(QWidget* _parent, QLineEdit* ed)
{
  EditTextDlg dlg(_parent, ed);
  dlg.exec();
}

void EditTextDlg::keyPressEvent(QKeyEvent* e)
{
  if ((e->state() == 0) && (e->key() == Key_F1)) {
       help->animateClick();
       e->accept();
  } else
    KDialog::keyPressEvent(e);
}

void EditTextDlg::slotCat()
{
  text->insert(font->text());
}

void EditTextDlg::slotFont()
{
  int i = -1;
  QRadioButton* rb;
  do
    rb = (QRadioButton*) bg1->find(++i);
  while (!rb->isChecked());
  const char fs[] = "HBOISZ";
  sfont[1] = fs[i];
  font->setText(sfont);
}

void EditTextDlg::slotPos()
{
  int i = -1;
  QRadioButton* rb;
  do
    rb = (QRadioButton*) bg2->find(++i);
  while (!rb->isChecked());
  const char ps[] = "UND";
  sfont[2] = ps[i];
  font->setText(sfont);
}

void EditTextDlg::slotOk()
{
  ed->setText(text->text());
  accept();
}

void EditTextDlg::slotHelp()
{
#if KDE_VERSION == 303
  kapp->startServiceByDesktopName("konqueror",
                                  QString("help:/kpl/edit-text.html"),
                                  0, 0, 0, "", true);
#else
  kapp->invokeHelp("SEC-EDIT-TEXT");
#endif
}
