/***************************************************************************
                          kbearquickconnectdata.cpp  -  description
                             -------------------
    begin                : Fri Jun 2 2000
    copyright            : (C) 2000 by Bjrn Sahlstrm
    email                : bjorn.sahlstrom@mail.bip.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qtooltip.h>
#include <qfont.h>
#include <kapp.h>
#include <klocale.h>
#include "kbearquickconnect.h"

void  KBearQuickConnect::initDialog(){
  this->resize(350,350);
  this->setMinimumSize(0,0);
  this->setFocus();
  UrlLabel= new QLabel(this,"UrlLabel");
  UrlLabel->setGeometry(20,30,200,20);
  UrlLabel->setMinimumSize(0,0);
  UrlLabel->setText(i18n("Hostname:"));

  HostNameEdit= new QLineEdit(this,"HostNameEdit");
  HostNameEdit->setGeometry(20,50,310,20);
  HostNameEdit->setMinimumSize(0,0);
  QToolTip::add(HostNameEdit,i18n("Enter URL to remote host here"));
  HostNameEdit->setFocus();
  HostNameEdit->setText("");

  PortLabel= new QLabel(this,"PortLabel");
  PortLabel->setGeometry(20,70,200,20);
  PortLabel->setMinimumSize(0,0);
  PortLabel->setText(i18n("Port:"));

  PortSpinBox= new QSpinBox(this,"PortSpinBox");
  PortSpinBox->setGeometry(20,90,60,20);
  PortSpinBox->setMinimumSize(0,0);
  QToolTip::add(PortSpinBox,i18n("Select port here"));
   PortSpinBox->setRange(0,65000);
  PortSpinBox->setValue(21);

  AnonymousCheck= new QCheckBox(this,"AnonymousCheck");
  AnonymousCheck->setGeometry(120,90,130,20);
  AnonymousCheck->setMinimumSize(0,0);
  AnonymousCheck->setText(i18n("Anonymous Login"));

  UserNameLabel= new QLabel(this,"UserNameLabel");
  UserNameLabel->setGeometry(20, 110,200,20);
  UserNameLabel->setMinimumSize(0,0);
  UserNameLabel->setText(i18n("Username:"));

  UserNameEdit= new QLineEdit(this,"UserNameEdit");
  UserNameEdit->setGeometry(20,130,230,20);
  UserNameEdit->setMinimumSize(0,0);
  QToolTip::add(UserNameEdit,i18n("Enter your user name here\nIf you leave this empty anonymous login is expected!!!"));
  UserNameEdit->setText("");

  PasswordLabel= new QLabel(this,"PasswordLabel");
  PasswordLabel->setGeometry(20,150,200,20);
  PasswordLabel->setMinimumSize(0,0);
  PasswordLabel->setText(i18n("Password:"));

  PasswordEdit= new QLineEdit(this,"PasswordEdit");
  PasswordEdit->setGeometry(20,170,230,20);
  PasswordEdit->setMinimumSize(0,0);
  QToolTip::add(PasswordEdit,i18n("Enter your password here"));
  PasswordEdit->setText("");

  RemoteDirLabel= new QLabel(this,"RemoteDirLabel");
  RemoteDirLabel->setGeometry(20,190,200,20);
  RemoteDirLabel->setMinimumSize(0,0);
  RemoteDirLabel->setText(i18n("Default Directory:"));

  RemoteDirEdit= new QLineEdit(this,"RemoteDirEdit");
  RemoteDirEdit->setGeometry(20,210,310,20);
  RemoteDirEdit->setMinimumSize(0,0);
  QToolTip::add(RemoteDirEdit,i18n("Enter start directory on remote host here"));
  RemoteDirEdit->setText("");

  saveToSiteManagerCheckBox= new QCheckBox(this,"SaveToSiteManagerCheckBox");
  saveToSiteManagerCheckBox->setGeometry(40,250,131,19);
  saveToSiteManagerCheckBox->setMinimumSize(0,0);
  saveToSiteManagerCheckBox->setText(i18n("Save to Sitemanager"));
  saveToSiteManagerCheckBox->setChecked( false );
  saveToSiteManagerCheckBox->setAutoResize(true);

  ConnectButton= new QPushButton(this,"ConnectButton");
  ConnectButton->setGeometry(20,290,90,40);
  ConnectButton->setMinimumSize(0,0);
  QToolTip::add(ConnectButton,i18n("Press button to connect"));
  ConnectButton->setFont(QFont("helvetica", 18, 50));
  ConnectButton->setText(i18n("Connect"));
  ConnectButton->setDefault(true);
  ConnectButton->setAutoDefault(true);

  CancelButton= new QPushButton(this,"CancelButton");
  CancelButton->setGeometry(240,290,90,40);
  CancelButton->setMinimumSize(0,0);
  QToolTip::add(CancelButton,i18n("Press button to cancel and exit dialog"));
  CancelButton->setFont(QFont("helvetica", 18, 50));
  CancelButton->setText(i18n("Cancel"));
}
