/***************************************************************************
                          mytext.h  -  description
                             -------------------
    begin                : Sat Sep 4 1999
    copyright            : (C) 1999 by Rolf Jakob
    email                : rjakob@duffy1.franken.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef MYTEXT_H
#define MYTEXT_H

#include <qwidget.h>
#include <qmultilinedit.h>
#include "mytext.h"
#include "filter.h"
#include "ktail_config.h"

#define ACTION_RAISE							1
#define ACTION_DEICONIFY					2
#define ACTION_DEICONIFYANDRAISE	3
#define ACTION_BEEP								4

class mybox : public QWidget
{
	Q_OBJECT
public:
	mybox(QWidget *parent=0, const char *name=0)
	: QWidget(parent, name) {};
	void resizeEvent (QResizeEvent *);
	QWidget *mychild;
	void setChild(QWidget *child);
	void removeChild();
};

class mytext : public QMultiLineEdit
{
	Q_OBJECT
public:
	mytext(QWidget *parent=0, const char *name=0);
	void mousePressEvent(QMouseEvent *);
	void setMaxLines(int);
	int getMaxLines() { return(maxLines); }
	void setFilter(const char *, bool);
	const char *getFilter();
	void insertLineAtEnd(const char *);
	void editFilter();
	bool filterIsExcl() { return(excludePattern); };
	void setActionCode(int n);
	int actionCode() { return(intActionCode); };
private:
	void insertSingleLineAtEnd(const char *, bool);
	int maxLines;
	bool lastLineComplete;
	filter *filterw;
	QRegExp *re;
	bool excludePattern;
	int intActionCode;
signals:
	void rightclicked();
	void altrightclicked();
	void middleclicked();
//	void changed(mytext *);
};

#endif





