/***************************************************************************
                          veditdialog.cpp  -  description
                             -------------------
    begin                : Thu Mar 23 2000
    copyright            : (C) 2000 by Friedrich W. H. Kossebau
    email                : Friedrich.W.H@Kossebau.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "veditdialog.h"

VEditDialog::VEditDialog( QString &LabelText, QWidget *parent, const char *name )
  : VDialog( parent,name ), 
    EditLine( this ),
    Label( &EditLine, LabelText, this )
{
  Layout.addWidget( &Label, 0, AlignLeft );
  Layout.addWidget( &EditLine );

  EditLine.setFixedHeight( EditLine.sizeHint().height() );
  EditLine.setMinimumWidth( EditLine.sizeHint().width() );
  Label.setFixedSize( Label.sizeHint() );
    
  finishLayout();
  
  EditLine.setFocus();
}


VEditDialog::~VEditDialog()
{
}


bool VEditDialog::edit( QString &Text, QString LabelText, QWidget *parent=0, const char *caption=0 )
{
  
  VEditDialog *Dialog = new VEditDialog( LabelText,parent);
  
  Dialog->setText( Text );
  bool Accepted = Dialog->exec();
  
  if( Accepted )
    Text = Dialog->text();
  
  delete Dialog;
  
  return Accepted;
}


