/* -------------------------------------------------------------------------- */
/*                                                                            */
/* [config.cpp]                Configuration Dialog                           */
/*                                                                            */
/* -------------------------------------------------------------------------- */
/*                                                                            */
/* Copyright (c) 1997 by Lars Doelle                                          */
/*                                                                            */
/* This file is part of Kom - a serial line terminal for KDE                  */
/*                                                                            */
/* The whole program is available under the GNU Public Software Licence.      */
/* See COPYING, the documenation, or <http://www.gnu.org> for details.        */
/*                                                                            */
/* -------------------------------------------------------------------------- */


#ifndef CONFIG_H
#define CONFIG_H

#include <qwidget.h>
#include <qlabel.h>
#include <ktabctl.h>
#include <qdialog.h>
#include <qpushbt.h>
#include <qgrpbox.h>
#include <qlayout.h>
#include <qcombo.h>
#include <qchkbox.h>
#include <qtooltip.h>

#include "constants.h"

// [Modem]
#define CONF_INIT_STRING    "Init String"
#define CONF_DIAL_SUFFIX    "Dial Suffix"
#define CONF_DIAL_PREFIX    "Dial Prefix"
// [Local]
#define CONF_LOCAL_YES      "Affirmation"
#define CONF_TIME_FORMAT    "Time Format"
#define CONF_DATE_FORMAT    "Date Format"
// [BBS]
#define CONF_LOGIN_PROTOCOL "Login Protocol"
#define CONF_BBS_NAME       "BBS Name"
#define CONF_CUSTOM_LOGIN   "Custom autologin"
#define CONF_DIAL_PHONE     "Phone Number"
#define CONF_EMULATION      "Emulation"
// [Serial]
#define CONF_STOPBITS       "Stopbits"
#define CONF_DATABITS       "Databits"
#define CONF_PARITY         "Parity"
#define CONF_DEVICE         "Device"
#define CONF_SPEED          "Speed"
#define CONF_HANDSHAKE      "Handshake"
// [General]
#define CONF_CAPTURE_FILE   "Capture File"
#define CONF_LOGO           "Logo"
#define CONF_UPLOAD_DIR     "Upload Directory"
#define CONF_DOWNLOAD_DIR   "Download Directory"
// [Identity]
#define CONF_ID_ALIAS       "Alias"
#define CONF_ID_PASSWORD    "Password"
#define CONF_ID_USERNAME    "Username"
#define CONF_ID_LOCATION    "Location"
#define CONF_ID_VOICE_NR    "Voice Phone Number"
#define CONF_ID_DATA_NR     "Data Phone Number"

class Config : public QWidget
/* Connection configuration */
{
    Q_OBJECT
public:
    Config(QWidget* parent=0, const char* name=0);
    ~Config();

private slots:
    void quit();
    void done();
    void save();
    void tabSelected(int);
    void setSectionDefault();
    virtual void closeEvent(QCloseEvent* e);

private:

    void makePages(KTabCtl* tc);
    QComboBox* addcombo(QWidget* p, QGridLayout* lay, int row, char* label);
    QLineEdit* addtextf(QWidget* p, QGridLayout* lay, int row, char* label, int len);
    QCheckBox* addcheck(QWidget* p, QGridLayout* lay, int row, char* label, int len);
    int ctabPage;
    int grps;

    QBoxLayout  *l1;
    QPalette     pal;
    QWidget**    widgets;
    QLayout**    layouts; // QLayout* layout[2][grps];
};

extern void config_init(char* rc);
extern const char* config_get(const char* key);
extern char* conv_controls(const char* key);
extern const char* conv_devices(const char* num);

#endif
