//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  This class represents a collection of PIM items, such as a folder on a mail- or
    ///  groupware-server.
    ///  Collections are hierarchical, i.e., they may have a parent collection.
    ///  @code
    ///  using namespace Akonadi;
    ///  // fetching all collections recursive, starting at the root collection
    ///  CollectionFetchJob job = new CollectionFetchJob( Collection.Root(), CollectionFetchJob.Recursive );
    ///  if ( job.Exec() ) {
    ///    Collection.List collections = job.Collections();
    ///    foreach( Collectioncollection, collections ) {
    ///      qDebug() << "Name:" << collection.name();
    ///    }
    ///  }
    ///  @endcode
    /// </remarks>        <author> Volker Krause <vkrause@kde.org>
    /// </author>
    ///         <short> Represents a collection of PIM items. </short>
    ///         <see> \ref</see>
    ///         <see> akonadi_concepts_collections</see>
    ///         <see> "Akonadi</see>
    ///         <see> Collection</see>
    ///         <see> Concept"</see>
    [SmokeClass("Akonadi::Collection")]
    public class Collection : Akonadi.Entity, IDisposable {
        protected Collection(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Collection), this);
        }
        private static SmokeInvocation staticInterceptor = null;
        static Collection() {
            staticInterceptor = new SmokeInvocation(typeof(Collection), null);
        }
        /// <remarks>
        ///  Describes rights of a collection.
        ///      </remarks>        <short>    Describes rights of a collection.</short>
        public enum Right {
            ReadOnly = 0x0,
            CanChangeItem = 0x1,
            CanCreateItem = 0x2,
            CanDeleteItem = 0x4,
            CanChangeCollection = 0x8,
            CanCreateCollection = 0x16,
            CanDeleteCollection = 0x32,
            AllRights = (CanChangeItem|CanCreateItem|CanDeleteItem|CanChangeCollection|CanCreateCollection|CanDeleteCollection),
        }
        /// <remarks>
        ///  Creates an invalid collection.
        ///      </remarks>        <short>    Creates an invalid collection.</short>
        public Collection() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Collection", "Collection()", typeof(void));
        }
        /// <remarks>
        ///  Create a new collection.
        /// <param> name="id" The unique identifier of the collection.
        ///      </param></remarks>        <short>    Create a new collection.</short>
        public Collection(long id) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Collection$", "Collection(qint64)", typeof(void), typeof(long), id);
        }
        /// <remarks>
        ///  Creates a collection from an <code>other</code> collection.
        ///      </remarks>        <short>    Creates a collection from an <code>other</code> collection.</short>
        public Collection(Akonadi.Collection other) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Collection#", "Collection(const Akonadi::Collection&)", typeof(void), typeof(Akonadi.Collection), other);
        }
        /// <remarks>
        ///  Returns the i18n'ed name of the collection.
        ///      </remarks>        <short>    Returns the i18n'ed name of the collection.</short>
        public string Name() {
            return (string) interceptor.Invoke("name", "name() const", typeof(string));
        }
        /// <remarks>
        ///  Sets the i18n'ed name of the collection.
        /// <param> name="name" The new collection name.
        ///      </param></remarks>        <short>    Sets the i18n'ed name of the collection.</short>
        public void SetName(string name) {
            interceptor.Invoke("setName$", "setName(const QString&)", typeof(void), typeof(string), name);
        }
        /// <remarks>
        ///  Returns the rights the user has on the collection.
        ///      </remarks>        <short>    Returns the rights the user has on the collection.</short>
        public uint Rights() {
            return (uint) interceptor.Invoke("rights", "rights() const", typeof(uint));
        }
        /// <remarks>
        ///  Sets the <code>rights</code> the user has on the collection.
        ///      </remarks>        <short>    Sets the <code>rights</code> the user has on the collection.</short>
        public void SetRights(uint rights) {
            interceptor.Invoke("setRights$", "setRights(Akonadi::Collection::Rights)", typeof(void), typeof(uint), rights);
        }
        /// <remarks>
        ///  Returns a list of possible content mimetypes,
        ///  e.g. message/rfc822, x-akonadi/collection for a mail folder that
        ///  supports sub-folders.
        ///     </remarks>        <short>    Returns a list of possible content mimetypes,  e.</short>
        public List<string> ContentMimeTypes() {
            return (List<string>) interceptor.Invoke("contentMimeTypes", "contentMimeTypes() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Sets the list of possible content mime <code>types.</code>
        ///      </remarks>        <short>    Sets the list of possible content mime <code>types.</code></short>
        public void SetContentMimeTypes(List<string> types) {
            interceptor.Invoke("setContentMimeTypes?", "setContentMimeTypes(const QStringList&)", typeof(void), typeof(List<string>), types);
        }
        /// <remarks>
        ///  Returns the identifier of the parent collection.
        ///      </remarks>        <short>    Returns the identifier of the parent collection.</short>
        public long Parent() {
            return (long) interceptor.Invoke("parent", "parent() const", typeof(long));
        }
        /// <remarks>
        ///  Sets the identifier of the <code>parent</code> collection.
        ///      </remarks>        <short>    Sets the identifier of the <code>parent</code> collection.</short>
        public void SetParent(long parent) {
            interceptor.Invoke("setParent$", "setParent(qint64)", typeof(void), typeof(long), parent);
        }
        /// <remarks>
        ///  Sets the parent <code>collection.</code>
        ///      </remarks>        <short>    Sets the parent <code>collection.</code></short>
        public void SetParent(Akonadi.Collection collection) {
            interceptor.Invoke("setParent#", "setParent(const Akonadi::Collection&)", typeof(void), typeof(Akonadi.Collection), collection);
        }
        /// <remarks>
        ///  Returns the parent remote identifier.
        ///  @note This usually returns nothing for collections retrieved from the backend.
        ///      </remarks>        <short>    Returns the parent remote identifier.</short>
        public string ParentRemoteId() {
            return (string) interceptor.Invoke("parentRemoteId", "parentRemoteId() const", typeof(string));
        }
        /// <remarks>
        ///  Sets the parent's remote <code>identifier.</code>
        ///      </remarks>        <short>    Sets the parent's remote <code>identifier.</code></short>
        public void SetParentRemoteId(string identifier) {
            interceptor.Invoke("setParentRemoteId$", "setParentRemoteId(const QString&)", typeof(void), typeof(string), identifier);
        }
        /// <remarks>
        ///  Returns the identifier of the resource owning the collection.
        ///      </remarks>        <short>    Returns the identifier of the resource owning the collection.</short>
        public string Resource() {
            return (string) interceptor.Invoke("resource", "resource() const", typeof(string));
        }
        /// <remarks>
        ///  Sets the <code>identifier</code> of the resource owning the collection.
        ///      </remarks>        <short>    Sets the <code>identifier</code> of the resource owning the collection.</short>
        public void SetResource(string identifier) {
            interceptor.Invoke("setResource$", "setResource(const QString&)", typeof(void), typeof(string), identifier);
        }
        /// <remarks>
        ///  Returns the cache policy of the collection.
        ///      </remarks>        <short>    Returns the cache policy of the collection.</short>
        public Akonadi.CachePolicy CachePolicy() {
            return (Akonadi.CachePolicy) interceptor.Invoke("cachePolicy", "cachePolicy() const", typeof(Akonadi.CachePolicy));
        }
        /// <remarks>
        ///  Sets the cache <code>policy</code> of the collection.
        ///      </remarks>        <short>    Sets the cache <code>policy</code> of the collection.</short>
        public void SetCachePolicy(Akonadi.CachePolicy policy) {
            interceptor.Invoke("setCachePolicy#", "setCachePolicy(const Akonadi::CachePolicy&)", typeof(void), typeof(Akonadi.CachePolicy), policy);
        }
        /// <remarks>
        ///  Returns the collection statistics of the collection.
        ///      </remarks>        <short>    Returns the collection statistics of the collection.</short>
        public Akonadi.CollectionStatistics Statistics() {
            return (Akonadi.CollectionStatistics) interceptor.Invoke("statistics", "statistics() const", typeof(Akonadi.CollectionStatistics));
        }
        /// <remarks>
        ///  Sets the collection <code>statistics</code> for the collection.
        ///      </remarks>        <short>    Sets the collection <code>statistics</code> for the collection.</short>
        public void SetStatistics(Akonadi.CollectionStatistics statistics) {
            interceptor.Invoke("setStatistics#", "setStatistics(const Akonadi::CollectionStatistics&)", typeof(void), typeof(Akonadi.CollectionStatistics), statistics);
        }
        /// <remarks>
        ///  Returns the collection url
        ///      </remarks>        <short>    Returns the collection url      </short>
        public KUrl Url() {
            return (KUrl) interceptor.Invoke("url", "url() const", typeof(KUrl));
        }
        ~Collection() {
            interceptor.Invoke("~Collection", "~Collection()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~Collection", "~Collection()", typeof(void));
        }
        /// <remarks>
        ///  Creates a collection from the given <code>url.</code>
        ///      </remarks>        <short>    Creates a collection from the given <code>url.</code></short>
        public static Akonadi.Collection FromUrl(KUrl url) {
            return (Akonadi.Collection) staticInterceptor.Invoke("fromUrl#", "fromUrl(const KUrl&)", typeof(Akonadi.Collection), typeof(KUrl), url);
        }
        /// <remarks>
        ///  Returns the root collection.
        ///      </remarks>        <short>    Returns the root collection.</short>
        public static Akonadi.Collection Root() {
            return (Akonadi.Collection) staticInterceptor.Invoke("root", "root()", typeof(Akonadi.Collection));
        }
        /// <remarks>
        ///  Returns the mimetype used for collections.
        ///      </remarks>        <short>    Returns the mimetype used for collections.</short>
        public static string MimeType() {
            return (string) staticInterceptor.Invoke("mimeType", "mimeType()", typeof(string));
        }
    }
}
