//Auto-generated by kalyptus. DO NOT EDIT.
namespace Soprano.Util {
    using Soprano;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \class AsyncModel asyncmodel.h Soprano/Server/AsyncModel
    ///  \brief Filter model that allows to perform operations
    ///  asyncroneously.
    ///  AsyncModel has two modes: AsyncModel.SingleThreaded and AsyncModel.MultiThreaded.
    ///  The main purpose of the AsyncModel.SingleThreaded mode is to protect a
    ///  Model against deadlocks in a single threaded situation.
    ///  AsyncModel.MultiThreaded mode provides real asyncroneous execution of
    ///  Model commands.
    ///  Usage:
    ///  <pre>
    ///  AsyncResult result = model.ListStatementsAsync( s );
    ///  connect( result, SIGNAL("resultReady(AsyncResult)"),
    ///           this, SLOT("slotResultReady(AsyncResult)") );
    ///  </pre>
    ///  \author Sebastian Trueg <trueg@kde.org>
    ///  \since 2.1
    ///          </remarks>        <short>    \class AsyncModel asyncmodel.</short>
    [SmokeClass("Soprano::Util::AsyncModel")]
    public class AsyncModel : Soprano.FilterModel, IDisposable {
        protected AsyncModel(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(AsyncModel), this);
        }
        /// <remarks>
        ///  The mode of the model, single vs. multi threaded execution.
        ///  \since 2.2
        ///              </remarks>        <short>    The mode of the model, single vs.</short>
        public enum AsyncModelMode {
            SingleThreaded = 0,
            MultiThreaded = 1,
        }
        /// <remarks>
        ///  Create a new Model.
        ///  \param parent The parent model to forward the operations to.
        ///              </remarks>        <short>    Create a new Model.</short>
        public AsyncModel(Soprano.Model parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("AsyncModel#", "AsyncModel(Soprano::Model*)", typeof(void), typeof(Soprano.Model), parent);
        }
        public AsyncModel() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("AsyncModel", "AsyncModel()", typeof(void));
        }
        /// <remarks>
        ///  Set the mode to be used. For historical reasons the default mode is
        ///  SingleThreaded.
        ///  \sa mode
        ///  \since 2.2
        ///              </remarks>        <short>    Set the mode to be used.</short>
        public void SetMode(Soprano.Util.AsyncModel.AsyncModelMode mode) {
            interceptor.Invoke("setMode$", "setMode(Soprano::Util::AsyncModel::AsyncModelMode)", typeof(void), typeof(Soprano.Util.AsyncModel.AsyncModelMode), mode);
        }
        /// <remarks>
        ///  The mode used by this model.
        ///  \sa setMode
        ///  \since 2.2
        ///              </remarks>        <short>    The mode used by this model.</short>
        public Soprano.Util.AsyncModel.AsyncModelMode Mode() {
            return (Soprano.Util.AsyncModel.AsyncModelMode) interceptor.Invoke("mode", "mode() const", typeof(Soprano.Util.AsyncModel.AsyncModelMode));
        }
        /// <remarks>
        ///  Asyncroneously add the Statement to the Model.
        ///  \param statement The Statement to add.
        ///  \sa addStatement
        ///  \return an AsyncResult with result type Error.ErrorCode
        ///  object which will signal when the result is ready.
        ///              </remarks>        <short>    Asyncroneously add the Statement to the Model.</short>
        public Soprano.Util.AsyncResult AddStatementAsync(Soprano.Statement statement) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("addStatementAsync#", "addStatementAsync(const Soprano::Statement&)", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Statement), statement);
        }
        /// <remarks>
        ///  \overload
        ///  \since 2.2
        ///              </remarks>        <short>    \overload </short>
        public Soprano.Util.AsyncResult AddStatementAsync(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3, Soprano.Node context) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("addStatementAsync####", "addStatementAsync(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&, const Soprano::Node&)", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3, typeof(Soprano.Node), context);
        }
        public Soprano.Util.AsyncResult AddStatementAsync(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("addStatementAsync###", "addStatementAsync(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&)", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3);
        }
        /// <remarks>
        ///  \overload
        ///  \since 2.2
        ///              </remarks>        <short>    \overload </short>
        public Soprano.Util.AsyncResult AddStatementsAsync(List<Soprano.Statement> statements) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("addStatementsAsync?", "addStatementsAsync(const QList<Soprano::Statement>&)", typeof(Soprano.Util.AsyncResult), typeof(List<Soprano.Statement>), statements);
        }
        /// <remarks>
        ///  Asyncroneously remove one statement. For removing statements
        ///  with wildward matching see removeAllStatementsAsync().
        ///  \param statement The statement that should be removed.
        ///  This has to be a valid statement.
        ///  \sa removeStatement
        ///  \return an AsyncResult with result type Error.ErrorCode
        ///  object which will signal when the result is ready.
        ///              </remarks>        <short>    Asyncroneously remove one statement.</short>
        public Soprano.Util.AsyncResult RemoveStatementAsync(Soprano.Statement statement) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("removeStatementAsync#", "removeStatementAsync(const Soprano::Statement&)", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Statement), statement);
        }
        /// <remarks>
        ///  \overload
        ///  \since 2.2
        ///              </remarks>        <short>    \overload </short>
        public Soprano.Util.AsyncResult RemoveStatementAsync(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3, Soprano.Node context) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("removeStatementAsync####", "removeStatementAsync(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&, const Soprano::Node&)", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3, typeof(Soprano.Node), context);
        }
        public Soprano.Util.AsyncResult RemoveStatementAsync(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("removeStatementAsync###", "removeStatementAsync(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&)", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3);
        }
        /// <remarks>
        ///  \overload
        ///  \since 2.2
        ///              </remarks>        <short>    \overload </short>
        public Soprano.Util.AsyncResult RemoveStatementsAsync(List<Soprano.Statement> statements) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("removeStatementsAsync?", "removeStatementsAsync(const QList<Soprano::Statement>&)", typeof(Soprano.Util.AsyncResult), typeof(List<Soprano.Statement>), statements);
        }
        /// <remarks>
        ///  Asyncroneously remove all statements that match the partial statement.
        ///  For removing one specific statement see removeStatement().
        ///  \param statement A possible partially defined statement that serves as
        ///  a filter for all statements that should be removed.
        ///  \sa removeAllStatements
        ///  \return an AsyncResult with result type Error.ErrorCode
        ///  object which will signal when the result is ready.
        ///              </remarks>        <short>    Asyncroneously remove all statements that match the partial statement.</short>
        public Soprano.Util.AsyncResult RemoveAllStatementsAsync(Soprano.Statement statement) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("removeAllStatementsAsync#", "removeAllStatementsAsync(const Soprano::Statement&)", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Statement), statement);
        }
        /// <remarks>
        ///  \overload
        ///  \since 2.2
        ///              </remarks>        <short>    \overload </short>
        public Soprano.Util.AsyncResult RemoveAllStatementsAsync(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3, Soprano.Node context) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("removeAllStatementsAsync####", "removeAllStatementsAsync(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&, const Soprano::Node&)", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3, typeof(Soprano.Node), context);
        }
        public Soprano.Util.AsyncResult RemoveAllStatementsAsync(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("removeAllStatementsAsync###", "removeAllStatementsAsync(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&)", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3);
        }
        /// <remarks>
        ///  Asyncroneously check if the Model does contain any Statement.
        ///  \sa isEmpty
        ///  \return an AsyncResult with result type bool
        ///  object which will signal when the result is ready.
        ///              </remarks>        <short>    Asyncroneously check if the Model does contain any Statement.</short>
        public Soprano.Util.AsyncResult IsEmptyAsync() {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("isEmptyAsync", "isEmptyAsync() const", typeof(Soprano.Util.AsyncResult));
        }
        /// <remarks>
        ///  Asyncroneously determine the number of statements stored in this Model.
        ///  \sa statementCount
        ///  \return an AsyncResult with result type int
        ///  object which will signal when the result is ready.
        ///              </remarks>        <short>    Asyncroneously determine the number of statements stored in this Model.</short>
        public Soprano.Util.AsyncResult StatementCountAsync() {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("statementCountAsync", "statementCountAsync() const", typeof(Soprano.Util.AsyncResult));
        }
        /// <remarks>
        ///  Asyncroneously return an iterator over Model Statements that "partial"
        ///  match the input Statement.
        ///  \param statement The partial Statement to match.
        ///  \sa listStatements
        ///  \return an AsyncResult with result type StatementIterator
        ///  object which will signal when the result is ready.
        ///              </remarks>        <short>    Asyncroneously return an iterator over Model Statements that "partial"  match the input Statement.</short>
        public Soprano.Util.AsyncResult ListStatementsAsync(Soprano.Statement statement) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("listStatementsAsync#", "listStatementsAsync(const Soprano::Statement&) const", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Statement), statement);
        }
        /// <remarks>
        ///  \overload
        ///  \since 2.2
        ///              </remarks>        <short>    \overload </short>
        public Soprano.Util.AsyncResult ListStatementsAsync(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3, Soprano.Node context) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("listStatementsAsync####", "listStatementsAsync(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&, const Soprano::Node&) const", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3, typeof(Soprano.Node), context);
        }
        public Soprano.Util.AsyncResult ListStatementsAsync(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("listStatementsAsync###", "listStatementsAsync(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&) const", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3);
        }
        /// <remarks>
        ///  \overload
        ///  Lists all statements in the Model asyncroneously.
        ///  \since 2.2
        ///              </remarks>        <short>    \overload </short>
        public Soprano.Util.AsyncResult ListStatementsAsync() {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("listStatementsAsync", "listStatementsAsync() const", typeof(Soprano.Util.AsyncResult));
        }
        /// <remarks>
        ///  Asyncroneously list all contexts in the model, i.e. all named graphs.
        ///  \sa listContexts
        ///  \return an AsyncResult with result type NodeIterator
        ///  object which will signal when the result is ready.
        ///              </remarks>        <short>    Asyncroneously list all contexts in the model, i.</short>
        public Soprano.Util.AsyncResult ListContextsAsync() {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("listContextsAsync", "listContextsAsync() const", typeof(Soprano.Util.AsyncResult));
        }
        /// <remarks>
        ///  Asyncroneously execute the given query over the Model.
        ///  This is a const read-only method. As such Model implementations should not
        ///  support SPARQL extensions such as INSERT or UPDATE through this method.
        ///  A future version of %Soprano will provide an additional API for queries
        ///  that change the Model.
        ///  \param query The query to evaluate.
        ///  \param language The %query language used to encode <pre>query</pre>.
        ///  \param userQueryLanguage If <pre>language</pre> equals Query.QueryLanguageUser
        ///  userQueryLanguage defines the language to use.
        ///  \sa executeQuery
        ///  \return an AsyncResult with result type QueryResultIterator
        ///  object which will signal when the result is ready.
        ///              </remarks>        <short>    Asyncroneously execute the given query over the Model.</short>
        public Soprano.Util.AsyncResult ExecuteQueryAsync(string query, Soprano.Query.QueryLanguage language, string userQueryLanguage) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("executeQueryAsync$$$", "executeQueryAsync(const QString&, Soprano::Query::QueryLanguage, const QString&) const", typeof(Soprano.Util.AsyncResult), typeof(string), query, typeof(Soprano.Query.QueryLanguage), language, typeof(string), userQueryLanguage);
        }
        public Soprano.Util.AsyncResult ExecuteQueryAsync(string query, Soprano.Query.QueryLanguage language) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("executeQueryAsync$$", "executeQueryAsync(const QString&, Soprano::Query::QueryLanguage) const", typeof(Soprano.Util.AsyncResult), typeof(string), query, typeof(Soprano.Query.QueryLanguage), language);
        }
        /// <remarks>
        ///  AsyncResult check if the model contains a statements.
        ///  \param statement The statement in question. This has to be a valid statement,
        ///  i.e. subject, predicate, and object need to be defined. If the context node
        ///  is empty the default graph is searched.
        ///  \sa containsStatement
        ///  \return an AsyncResult with result type bool
        ///  object which will signal when the result is ready.
        ///              </remarks>        <short>    AsyncResult check if the model contains a statements.</short>
        public Soprano.Util.AsyncResult ContainsStatementAsync(Soprano.Statement statement) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("containsStatementAsync#", "containsStatementAsync(const Soprano::Statement&) const", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Statement), statement);
        }
        /// <remarks>
        ///  \overload
        ///  \since 2.2
        ///              </remarks>        <short>    \overload </short>
        public Soprano.Util.AsyncResult ContainsStatementAsync(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3, Soprano.Node context) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("containsStatementAsync####", "containsStatementAsync(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&, const Soprano::Node&) const", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3, typeof(Soprano.Node), context);
        }
        public Soprano.Util.AsyncResult ContainsStatementAsync(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("containsStatementAsync###", "containsStatementAsync(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&) const", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3);
        }
        /// <remarks>
        ///  Asyncroneously check if the model contains certain statements.
        ///  \param statement A partially defined statement that serves as
        ///  a pattern.
        ///  \sa containsAnyStatement
        ///  \return an AsyncResult with result type bool
        ///  object which will signal when the result is ready.
        ///              </remarks>        <short>    Asyncroneously check if the model contains certain statements.</short>
        public Soprano.Util.AsyncResult ContainsAnyStatementAsync(Soprano.Statement statement) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("containsAnyStatementAsync#", "containsAnyStatementAsync(const Soprano::Statement&) const", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Statement), statement);
        }
        /// <remarks>
        ///  \overload
        ///  \since 2.2
        ///              </remarks>        <short>    \overload </short>
        public Soprano.Util.AsyncResult ContainsAnyStatementAsync(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3, Soprano.Node context) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("containsAnyStatementAsync####", "containsAnyStatementAsync(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&, const Soprano::Node&) const", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3, typeof(Soprano.Node), context);
        }
        public Soprano.Util.AsyncResult ContainsAnyStatementAsync(Soprano.Node subject, Soprano.Node predicate, Soprano.Node arg3) {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("containsAnyStatementAsync###", "containsAnyStatementAsync(const Soprano::Node&, const Soprano::Node&, const Soprano::Node&) const", typeof(Soprano.Util.AsyncResult), typeof(Soprano.Node), subject, typeof(Soprano.Node), predicate, typeof(Soprano.Node), arg3);
        }
        /// <remarks>
        ///  Asyncroneously create a new blank node with a unique identifier.
        ///  \sa createBlankNode
        ///  \return an AsyncResult with result type Node
        ///  object which will signal when the result is ready.
        ///              </remarks>        <short>    Asyncroneously create a new blank node with a unique identifier.</short>
        public Soprano.Util.AsyncResult CreateBlankNodeAsync() {
            return (Soprano.Util.AsyncResult) interceptor.Invoke("createBlankNodeAsync", "createBlankNodeAsync()", typeof(Soprano.Util.AsyncResult));
        }
        ~AsyncModel() {
            interceptor.Invoke("~AsyncModel", "~AsyncModel()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~AsyncModel", "~AsyncModel()", typeof(void));
        }
        protected new IAsyncModelSignals Emit {
            get { return (IAsyncModelSignals) Q_EMIT; }
        }
    }

    public interface IAsyncModelSignals : Soprano.IFilterModelSignals {
    }
}
