//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  \brief External modification extension interface for the Document.
    ///  \ingroup kte_group_doc_extensions
    ///  \section modiface_intro Introduction
    ///  The class ModificationInterface provides methods to handle modifications
    ///  of all opened files caused by external programs. Whenever the
    ///  modified-on-disk state changes the signal modifiedOnDisk() is emitted
    ///  along with a ModifiedOnDiskReason. Set the state by calling
    ///  setModifiedOnDisk(). Whether the Editor should show warning dialogs to
    ///  inform the user about external modified files can be controlled with
    ///  setModifiedOnDiskWarning(). The slot modifiedOnDisk() is called to ask
    ///  the user what to do whenever a file was modified.
    ///  \section modiface_access Accessing the ModificationInterface
    ///  The ModificationInterface is supposed to be an extension interface for a
    ///  Document, i.e. the Document inherits the interface \e provided that the
    ///  used KTextEditor library implements the interface. Use qobject_cast to
    ///  access the interface:
    ///  <pre>
    ///  // doc is of type KTextEditor.Document
    ///  KTextEditor.ModificationInterface iface =
    ///      qobject_cast<KTextEditor.ModificationInterface>( doc );
    ///  if( iface ) {
    ///      // the implementation supports the interface
    ///      // do stuff
    ///  }
    ///  </pre>
    ///  \see KTextEditor.Document
    ///  \author Christoph Cullmann \<cullmann@kde.org\>
    ///  </remarks>        <short>    \brief External modification extension interface for the Document.</short>
    [SmokeClass("KTextEditor::ModificationInterface")]
    public class ModificationInterface : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected ModificationInterface(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(ModificationInterface), this);
        }
        /// <remarks>
        ///  Reasons why a document is modified on disk.
        ///      </remarks>        <short>    Reasons why a document is modified on disk.</short>
        public enum ModifiedOnDiskReason {
            OnDiskUnmodified = 0,
            OnDiskModified = 1,
            OnDiskCreated = 2,
            OnDiskDeleted = 3,
        }
        public ModificationInterface() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ModificationInterface", "ModificationInterface()", typeof(void));
        }
        /// <remarks>
        ///  Set the document's modified-on-disk state to <pre>reason</pre>.
        ///  KTextEditor implementations should emit the signal modifiedOnDisk()
        ///  along with the reason. When the document is in a clean state again the
        ///  reason should be ModifiedOnDiskReason.OnDiskUnmodified.
        ///  \param reason the modified-on-disk reason.
        ///  \see ModifiedOnDiskReason, modifiedOnDisk()
        ///      </remarks>        <short>    Set the document's modified-on-disk state to \p reason.</short>
        [SmokeMethod("setModifiedOnDisk(KTextEditor::ModificationInterface::ModifiedOnDiskReason)")]
        public virtual void SetModifiedOnDisk(KTextEditor.ModificationInterface.ModifiedOnDiskReason reason) {
            interceptor.Invoke("setModifiedOnDisk$", "setModifiedOnDisk(KTextEditor::ModificationInterface::ModifiedOnDiskReason)", typeof(void), typeof(KTextEditor.ModificationInterface.ModifiedOnDiskReason), reason);
        }
        /// <remarks>
        ///  Control, whether the editor should show a warning dialog whenever a file
        ///  was modified on disk. If <pre>on</pre> is \e true the editor will show warning
        ///  dialogs.
        ///  \param on controls, whether the editor should show a warning dialog for
        ///         files modified on disk
        ///     </remarks>        <short>    Control, whether the editor should show a warning dialog whenever a file  was modified on disk.</short>
        [SmokeMethod("setModifiedOnDiskWarning(bool)")]
        public virtual void SetModifiedOnDiskWarning(bool on) {
            interceptor.Invoke("setModifiedOnDiskWarning$", "setModifiedOnDiskWarning(bool)", typeof(void), typeof(bool), on);
        }
        /// <remarks>
        ///  Ask the user what to do, if the file was modified on disk.
        ///  The argument <pre>view</pre> is used to avoid asking again, when the editor
        ///  regains focus after the dialog is hidden.
        ///  \param view the view that should be notified of the user's decision
        ///  \see setModifiedOnDisk(), modifiedOnDisk()
        ///      </remarks>        <short>    Ask the user what to do, if the file was modified on disk.</short>
        [SmokeMethod("slotModifiedOnDisk(KTextEditor::View*)")]
        public virtual void SlotModifiedOnDisk(KTextEditor.View view) {
            interceptor.Invoke("slotModifiedOnDisk#", "slotModifiedOnDisk(KTextEditor::View*)", typeof(void), typeof(KTextEditor.View), view);
        }
        [SmokeMethod("slotModifiedOnDisk()")]
        public virtual void SlotModifiedOnDisk() {
            interceptor.Invoke("slotModifiedOnDisk", "slotModifiedOnDisk()", typeof(void));
        }
        /// <remarks>
        ///  This signal is emitted whenever the <pre>document</pre> changed its
        ///  modified-on-disk state.
        ///  \param document the Document object that represents the file on disk
        ///  \param isModified if \e true, the file was modified rather than created
        ///         or deleted
        ///  \param reason the reason why the signal was emitted
        ///  \see setModifiedOnDisk()
        ///      </remarks>        <short>    This signal is emitted whenever the \p document changed its  modified-on-disk state.</short>
        [SmokeMethod("modifiedOnDisk(KTextEditor::Document*, bool, KTextEditor::ModificationInterface::ModifiedOnDiskReason)")]
        public virtual void ModifiedOnDisk(KTextEditor.Document document, bool isModified, KTextEditor.ModificationInterface.ModifiedOnDiskReason reason) {
            interceptor.Invoke("modifiedOnDisk#$$", "modifiedOnDisk(KTextEditor::Document*, bool, KTextEditor::ModificationInterface::ModifiedOnDiskReason)", typeof(void), typeof(KTextEditor.Document), document, typeof(bool), isModified, typeof(KTextEditor.ModificationInterface.ModifiedOnDiskReason), reason);
        }
        ~ModificationInterface() {
            interceptor.Invoke("~ModificationInterface", "~ModificationInterface()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~ModificationInterface", "~ModificationInterface()", typeof(void));
        }
    }
}
