/*
 * Copyright (C) 2006-2009 Stephan Kulow <coolo@kde.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of 
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef FORTYEIGHTSOLVER_H
#define FORTYEIGHTSOLVER_H

class Fortyeight;
#include "patsolve.h"


class FortyeightSolver : public Solver
{
public:
    FortyeightSolver(const Fortyeight *dealer);
    int good_automove(int o, int r);
    virtual int get_possible_moves(int *a, int *numout);
    virtual bool isWon();
    virtual void make_move(MOVE *m);
    virtual void undo_move(MOVE *m);
    virtual int getOuts();
    virtual int getClusterNumber();
    virtual void translate_layout();
    virtual void unpack_cluster( int k );
    virtual MoveHint translateMove(const MOVE &m);
    bool checkMove( int from, int to, MOVE *mp );

    virtual void print_layout();

    const Fortyeight *deal;
    bool lastdeal;
    int freestores;
};

#endif // FORTYEIGHTSOLVER_H
