/* This file is part of the KDE project
 * Copyright (C) 2009 Fredy Yanardi <fyanardi@gmail.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "GoogleSuggestionEngine.h"

#include <KDebug>
#include <KUrl>

#include <QtCore/QStringList>
#include <QtXml/QXmlStreamReader>

GoogleSuggestionEngine::GoogleSuggestionEngine(QObject *parent)
    : SuggestionEngine("google", parent)
{
}

QStringList GoogleSuggestionEngine::parseSuggestion(const QByteArray &response) const
{
    /* This XML parsing code is taken from Ariya Hidayat's Google Suggestion parser
     * (C) 2009 by Ariya Hidayat */
    QXmlStreamReader xml(response);
     
    QStringList suggestionsList;
    while (!xml.atEnd()) {
        xml.readNext();
        if (xml.tokenType() == QXmlStreamReader::StartElement) {
            if (xml.name() == QLatin1String("suggestion")) {
                QStringRef str = xml.attributes().value(QLatin1String("data"));
                suggestionsList << str.toString();
            }
        }
    }

    return suggestionsList;
}

#include "GoogleSuggestionEngine.moc"

