//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  When a KXmlGuiWindow is set, the XMLGUI defined context menu
    ///  <code>akonadi_itemview_contextmenu</code> is used if available.
    ///  Example:
    ///  @code
    ///  class MyWindow : public KXmlGuiWindow
    ///  {
    ///    public     MyWindow()
    ///     {
    ///       Akonadi.ItemView view = new Akonadi.ItemView( this, this );
    ///       setCentralWidget( view );
    ///       Akonadi.ItemModel model = new Akonadi.ItemModel( this );
    ///       view.SetModel( model );
    ///     }
    ///  }
    ///  @endcode
    ///  See <see cref="IItemViewSignals"></see> for signals emitted by ItemView
    /// </remarks>        <author> Tobias Koenig <tokoe@kde.org>
    ///  </author>
    ///         <short> A view to show an item list provided by an ItemModel. </short>
    [SmokeClass("Akonadi::ItemView")]
    public class ItemView : QTreeView, IDisposable {
        protected ItemView(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(ItemView), this);
        }
        /// <remarks>
        ///  Creates a new item view.
        /// <param> name="parent" The parent widget.
        ///      </param></remarks>        <short>    Creates a new item view.</short>
        public ItemView(QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ItemView#", "ItemView(QWidget*)", typeof(void), typeof(QWidget), parent);
        }
        public ItemView() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ItemView", "ItemView()", typeof(void));
        }
        /// <remarks>
        ///  Creates a new item view.
        /// <param> name="xmlGuiWindow" The KXmlGuiWindow this is used in.
        ///                      This is needed for the XMLGUI based context menu.
        ///                      Passing 0 is ok and will disable the builtin context menu.
        /// </param><param> name="parent" The parent widget.
        ///      </param></remarks>        <short>    Creates a new item view.</short>
        public ItemView(KXmlGuiWindow xmlGuiWindow, QWidget parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ItemView##", "ItemView(KXmlGuiWindow*, QWidget*)", typeof(void), typeof(KXmlGuiWindow), xmlGuiWindow, typeof(QWidget), parent);
        }
        public ItemView(KXmlGuiWindow xmlGuiWindow) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ItemView#", "ItemView(KXmlGuiWindow*)", typeof(void), typeof(KXmlGuiWindow), xmlGuiWindow);
        }
        /// <remarks>
        ///  Sets the KXmlGuiWindow which this view is used in.
        ///  This is needed if you want to use the built-in context menu.
        /// <param> name="xmlGuiWindow" The KXmlGuiWindow this view is used in.
        ///      </param></remarks>        <short>    Sets the KXmlGuiWindow which this view is used in.</short>
        public void SetXmlGuiWindow(KXmlGuiWindow xmlGuiWindow) {
            interceptor.Invoke("setXmlGuiWindow#", "setXmlGuiWindow(KXmlGuiWindow*)", typeof(void), typeof(KXmlGuiWindow), xmlGuiWindow);
        }
        [SmokeMethod("setModel(QAbstractItemModel*)")]
        public override void SetModel(QAbstractItemModel model) {
            interceptor.Invoke("setModel#", "setModel(QAbstractItemModel*)", typeof(void), typeof(QAbstractItemModel), model);
        }
        [SmokeMethod("contextMenuEvent(QContextMenuEvent*)")]
        protected override void ContextMenuEvent(QContextMenuEvent arg1) {
            interceptor.Invoke("contextMenuEvent#", "contextMenuEvent(QContextMenuEvent*)", typeof(void), typeof(QContextMenuEvent), arg1);
        }
        ~ItemView() {
            interceptor.Invoke("~ItemView", "~ItemView()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~ItemView", "~ItemView()", typeof(void));
        }
        protected new IItemViewSignals Emit {
            get { return (IItemViewSignals) Q_EMIT; }
        }
    }

    public interface IItemViewSignals : IQTreeViewSignals {
        /// <remarks>
        ///  This signal is emitted whenever the user has activated
        ///  an item in the view.
        /// <param> name="item" The activated item.
        ///      </param></remarks>        <short>    This signal is emitted whenever the user has activated  an item in the view.</short>
        [Q_SIGNAL("void activated(Akonadi::Item)")]
        void Activated(Akonadi.Item item);
        /// <remarks>
        ///  This signal is emitted whenever the current item
        ///  in the view has changed.
        /// <param> name="item" The current item.
        ///      </param></remarks>        <short>    This signal is emitted whenever the current item  in the view has changed.</short>
        [Q_SIGNAL("void currentChanged(Akonadi::Item)")]
        void CurrentChanged(Akonadi.Item item);
    }
}
