//Auto-generated by kalyptus. DO NOT EDIT.
namespace KTextEditor {
    using Kimono;
    using System;
    using Qyoto;
    using System.Collections.Generic;
    /// <remarks>
    ///  \brief A KParts derived class representing a text document.
    ///  Topics:
    ///   - \ref doc_intro
    ///   - \ref doc_manipulation
    ///   - \ref doc_views
    ///   - \ref doc_extensions
    ///  \section doc_intro Introduction
    ///  The Document class represents a pure text document providing methods to
    ///  modify the content and create views. A document can have any number
    ///  of views, each view representing the same content, i.e. all views are
    ///  synchronized. Support for text selection is handeled by a View and text
    ///  format attribues by the Attribute class.
    ///  To load a document call KParts.ReadOnlyPart.OpenUrl().
    ///  To reload a document from a file call documentReload(), to save the
    ///  document call documentSave() or documentSaveAs(). Whenever the modified
    ///  state of the document changes the signal modifiedChanged() is emitted.
    ///  Check the modified state with KParts.ReadWritePart.IsModified().
    ///  Further signals are documentUrlChanged(). The encoding can be specified
    ///  with setEncoding(), however this will only take effect on file reload and
    ///  file save.
    ///  \section doc_manipulation Text Manipulation
    ///  Get the whole content with text() and set new content with setText().
    ///  Call insertText() or insertLine() to insert new text or removeText()
    ///  and removeLine() to remove content. Whenever the document's content
    ///  changed the signal textChanged() is emitted. Additional signals are
    ///  textInserted() and textRemoved().
    ///  If the editor part supports it a document provides full undo/redo history.
    ///  Text manipulation actions can be grouped together using startEditing()
    ///  and endEditing(). All actions inbetween are grouped together to only one
    ///  undo/redo action. Due to internal reference counting you can call
    ///  startEditing() and endEditing() as often as you wish, but make sure you
    ///  call endEditing() exactly as often as you call startEditing(), otherwise
    ///  the reference counter gets confused.
    ///  \section doc_views Document Views
    ///  A View displays the document's content. As already mentioned a document
    ///  can have any number of views, all synchronized. Get a list of all views
    ///  with views(). Only one of the views can be active (i.e. has focus), get
    ///  it by using activeView(). Create a new view with createView(). Every time
    ///  a new view is created the signal viewCreated() is emitted.
    ///  \section doc_extensions Document Extension Interfaces
    ///  A simple document represents text and provides text manipulation methods.
    ///  However, a real text editor should support advanced concepts like session
    ///  support, textsearch support, bookmark/general mark support etc. That is why
    ///  the KTextEditor library provides several additional interfaces to extend
    ///  a document's capabilities via multiple inheritance.
    ///  More information about interfaces for the document can be found in
    ///  \ref kte_group_doc_extensions.
    ///  \see KParts.ReadWritePart, KTextEditor.Editor, KTextEditor.View,
    ///       KTextEditor.MarkInterface,
    ///       KTextEditor.ModificationInterface, KTextEditor.SearchInterface,
    ///       KTextEditor.SessionConfigInterface, KTextEditor.SmartInterface,
    ///       KTextEditor.VariableInterface
    ///  \author Christoph Cullmann \<cullmann@kde.org\>
    ///   See <see cref="IDocumentSignals"></see> for signals emitted by Document
    /// </remarks>        <short>    \brief A KParts derived class representing a text document.</short>
    [SmokeClass("KTextEditor::Document")]
    public partial class Document : KParts.ReadWritePart, IDisposable {
        protected Document(Type dummy) : base((Type) null) {}
        protected new void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(Document), this);
        }
        /// <remarks>
        ///  Constructor.
        ///  Create a new document with <pre>parent</pre>.
        ///  \param parent parent object
        ///  \see Editor.CreateDocument()
        ///      </remarks>        <short>    Constructor.</short>
        public Document(QObject parent) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Document#", "Document(QObject*)", typeof(void), typeof(QObject), parent);
        }
        public Document() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("Document", "Document()", typeof(void));
        }
        /// <remarks>
        ///  Get the global editor object. The editor part implementation must
        ///  ensure that this object exists as long as any factory or document
        ///  object exists.
        ///  \return global KTextEditor.Editor object
        ///  \see KTextEditor.Editor
        ///      </remarks>        <short>    Get the global editor object.</short>
        [SmokeMethod("editor()")]
        public virtual KTextEditor.Editor Editor() {
            return (KTextEditor.Editor) interceptor.Invoke("editor", "editor()", typeof(KTextEditor.Editor));
        }
        /// <remarks>
        ///  Create a new view attached to <code>parent.</code>
        /// <param> name="parent" parent widget
        /// </param></remarks>        <return> the new view
        ///      </return>
        ///         <short>    Create a new view attached to <code>parent.</code></short>
        [SmokeMethod("createView(QWidget*)")]
        public virtual KTextEditor.View CreateView(QWidget parent) {
            return (KTextEditor.View) interceptor.Invoke("createView#", "createView(QWidget*)", typeof(KTextEditor.View), typeof(QWidget), parent);
        }
        /// <remarks>
        ///  Return the view which currently has user focus, if any.
        ///      </remarks>        <short>    Return the view which currently has user focus, if any.</short>
        [SmokeMethod("activeView() const")]
        public virtual KTextEditor.View ActiveView() {
            return (KTextEditor.View) interceptor.Invoke("activeView", "activeView() const", typeof(KTextEditor.View));
        }
        /// <remarks>
        ///  Returns the views pre-casted to KTextEditor.View%s
        ///      </remarks>        <short>    Returns the views pre-casted to KTextEditor.View%s      </short>
        [SmokeMethod("views() const")]
        public virtual List<KTextEditor.View> Views() {
            return (List<KTextEditor.View>) interceptor.Invoke("views", "views() const", typeof(List<KTextEditor.View>));
        }
        /// <remarks>
        ///  Get this document's name.
        ///  The editor part should provide some meaningful name, like some unique
        ///  "Untitled XYZ" for the document - \e without URL or basename for
        ///  documents with url.
        ///  \return readable document name
        ///      </remarks>        <short>    Get this document's name.</short>
        [SmokeMethod("documentName() const")]
        public virtual string DocumentName() {
            return (string) interceptor.Invoke("documentName", "documentName() const", typeof(string));
        }
        /// <remarks>
        ///  Get this document's mimetype.
        ///  \return mimetype
        ///      </remarks>        <short>    Get this document's mimetype.</short>
        [SmokeMethod("mimeType()")]
        public virtual string MimeType() {
            return (string) interceptor.Invoke("mimeType", "mimeType()", typeof(string));
        }
        /// <remarks>
        ///  Set the encoding for this document. This encoding will be used
        ///  while loading and saving files, it will \e not affect the already
        ///  existing content of the document, e.g. if the file has already been
        ///  opened without the correct encoding, this will \e not fix it, you
        ///  would for example need to trigger a reload for this.
        ///  \param encoding new encoding for the document, the name must be
        ///         accepted by QTextCodec, if an empty encoding name is given, the
        ///         part should fallback to its own default encoding, e.g. the
        ///         system encoding or the global user settings
        ///  \return \e true on success, or \e false, if the encoding could not be set.
        ///  \see encoding()
        ///      </remarks>        <short>    Set the encoding for this document.</short>
        [SmokeMethod("setEncoding(const QString&)")]
        public virtual bool SetEncoding(string encoding) {
            return (bool) interceptor.Invoke("setEncoding$", "setEncoding(const QString&)", typeof(bool), typeof(string), encoding);
        }
        /// <remarks>
        ///  Get the current chosen encoding. The return value is an empty string,
        ///  if the document uses the default encoding of the editor and no own
        ///  special encoding.
        ///  \return current encoding of the document
        ///  \see setEncoding()
        ///      </remarks>        <short>    Get the current chosen encoding.</short>
        [SmokeMethod("encoding() const")]
        public virtual string Encoding() {
            return (string) interceptor.Invoke("encoding", "encoding() const", typeof(string));
        }
        /// <remarks>
        ///  Reload the current file.
        ///  The user will be prompted by the part on changes and more and can
        ///  cancel this action if it can harm.
        ///  \return \e true if the reload has been done, otherwise \e false. If
        ///          the document has no url set, it will just return \e false.
        ///      </remarks>        <short>    Reload the current file.</short>
        [SmokeMethod("documentReload()")]
        public virtual bool DocumentReload() {
            return (bool) interceptor.Invoke("documentReload", "documentReload()", typeof(bool));
        }
        /// <remarks>
        ///  Save the current file.
        ///  The user will be asked for a filename if needed and more.
        ///  \return \e true on success, i.e. the save has been done, otherwise
        ///          \e false
        ///      </remarks>        <short>    Save the current file.</short>
        [SmokeMethod("documentSave()")]
        public virtual bool DocumentSave() {
            return (bool) interceptor.Invoke("documentSave", "documentSave()", typeof(bool));
        }
        /// <remarks>
        ///  Save the current file to another location.
        ///  The user will be asked for a filename and more.
        ///  \return \e true on success, i.e. the save has been done, otherwise
        ///          \e false
        ///      </remarks>        <short>    Save the current file to another location.</short>
        [SmokeMethod("documentSaveAs()")]
        public virtual bool DocumentSaveAs() {
            return (bool) interceptor.Invoke("documentSaveAs", "documentSaveAs()", typeof(bool));
        }
        /// <remarks>
        ///  Begin an editing sequence.
        ///  Edit commands during this sequence will be bunched together so that
        ///  they represent a single undo command in the editor, and so that
        ///  repaint events do not occur inbetween.
        ///  Your application should \e not return control to the event loop while
        ///  it has an unterminated (i.e. no matching endEditing() call) editing
        ///  sequence (result undefined) - so do all of your work in one go!
        ///  This call stacks, like the endEditing() calls, this means you can
        ///  safely call it three times in a row for example if you call
        ///  endEditing() three times, too, it internaly just does counting the
        ///  running editing sessions.
        ///  If the texteditor part does not support these transactions,
        ///  both calls just do nothing.
        ///  \return \e true on success, otherwise \e false. Parts not supporting
        ///          it should return \e false
        ///  \see endEditing()
        ///      </remarks>        <short>    Begin an editing sequence.</short>
        [SmokeMethod("startEditing()")]
        public virtual bool StartEditing() {
            return (bool) interceptor.Invoke("startEditing", "startEditing()", typeof(bool));
        }
        /// <remarks>
        ///  End an editing sequence.
        ///  \return \e true on success, otherwise \e false. Parts not supporting
        ///          it should return \e false.
        ///  \see startEditing() for more details
        ///      </remarks>        <short>    End an editing sequence.</short>
        [SmokeMethod("endEditing()")]
        public virtual bool EndEditing() {
            return (bool) interceptor.Invoke("endEditing", "endEditing()", typeof(bool));
        }
        /// <remarks>
        ///  Get the document content.
        ///  \return the complete document content
        ///  \see setText()
        ///      </remarks>        <short>    Get the document content.</short>
        [SmokeMethod("text() const")]
        public virtual string Text() {
            return (string) interceptor.Invoke("text", "text() const", typeof(string));
        }
        /// <remarks>
        ///  Get the document content within the given <pre>range</pre>.
        ///  \param range the range of text to retrieve
        ///  \param block Set this to \e true to receive text in a visual block,
        ///         rather than everything inside <pre>range</pre>.
        ///  \return the requested text part, or string() for invalid ranges.
        ///  \see setText()
        ///      </remarks>        <short>    Get the document content within the given \p range.</short>
        [SmokeMethod("text(const KTextEditor::Range&, bool) const")]
        public virtual string Text(KTextEditor.Range range, bool block) {
            return (string) interceptor.Invoke("text#$", "text(const KTextEditor::Range&, bool) const", typeof(string), typeof(KTextEditor.Range), range, typeof(bool), block);
        }
        [SmokeMethod("text(const KTextEditor::Range&) const")]
        public virtual string Text(KTextEditor.Range range) {
            return (string) interceptor.Invoke("text#", "text(const KTextEditor::Range&) const", typeof(string), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  Get the character at <pre>cursor</pre>.
        ///  \param position the location of the character to retrieve
        ///  \return the requested character, or QChar() for invalid cursors.
        ///  \see setText()
        ///      </remarks>        <short>    Get the character at \p cursor.</short>
        [SmokeMethod("character(const KTextEditor::Cursor&) const")]
        public virtual QChar Character(KTextEditor.Cursor position) {
            return (QChar) interceptor.Invoke("character#", "character(const KTextEditor::Cursor&) const", typeof(QChar), typeof(KTextEditor.Cursor), position);
        }
        /// <remarks>
        ///  Get the document content within the given <pre>range</pre>.
        ///  \param range the range of text to retrieve
        ///  \param block Set this to \e true to receive text in a visual block,
        ///         rather than everything inside <pre>range</pre>.
        ///  \return the requested text lines, or List<string>() for invalid ranges.
        ///          no end of line termination is included.
        ///  \see setText()
        ///      </remarks>        <short>    Get the document content within the given \p range.</short>
        [SmokeMethod("textLines(const KTextEditor::Range&, bool) const")]
        public virtual List<string> TextLines(KTextEditor.Range range, bool block) {
            return (List<string>) interceptor.Invoke("textLines#$", "textLines(const KTextEditor::Range&, bool) const", typeof(List<string>), typeof(KTextEditor.Range), range, typeof(bool), block);
        }
        [SmokeMethod("textLines(const KTextEditor::Range&) const")]
        public virtual List<string> TextLines(KTextEditor.Range range) {
            return (List<string>) interceptor.Invoke("textLines#", "textLines(const KTextEditor::Range&) const", typeof(List<string>), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  Get a single text line.
        ///  \param line the wanted line
        ///  \return the requested line, or "" for invalid line numbers
        ///  \see text(), lineLength()
        ///      </remarks>        <short>    Get a single text line.</short>
        [SmokeMethod("line(int) const")]
        public virtual string Line(int line) {
            return (string) interceptor.Invoke("line$", "line(int) const", typeof(string), typeof(int), line);
        }
        /// <remarks>
        ///  Get the count of lines of the document.
        ///  \return the current number of lines in the document
        ///  \see length()
        ///      </remarks>        <short>    Get the count of lines of the document.</short>
        [SmokeMethod("lines() const")]
        public virtual int Lines() {
            return (int) interceptor.Invoke("lines", "lines() const", typeof(int));
        }
        /// <remarks>
        ///  End position of the document.
        ///  \return The last column on the last line of the document
        ///  \see all()
        ///      </remarks>        <short>    End position of the document.</short>
        [SmokeMethod("documentEnd() const")]
        public virtual KTextEditor.Cursor DocumentEnd() {
            return (KTextEditor.Cursor) interceptor.Invoke("documentEnd", "documentEnd() const", typeof(KTextEditor.Cursor));
        }
        /// <remarks>
        ///  A Range which encompasses the whole document.
        ///  \return A range from the start to the end of the document
        ///      </remarks>        <short>    A Range which encompasses the whole document.</short>
        public KTextEditor.Range DocumentRange() {
            return (KTextEditor.Range) interceptor.Invoke("documentRange", "documentRange() const", typeof(KTextEditor.Range));
        }
        /// <remarks>
        ///  Get the count of characters in the document. A TAB character counts as
        ///  only one character.
        ///  \return the number of characters in the document
        ///  \see lines()
        ///      </remarks>        <short>    Get the count of characters in the document.</short>
        [SmokeMethod("totalCharacters() const")]
        public virtual int TotalCharacters() {
            return (int) interceptor.Invoke("totalCharacters", "totalCharacters() const", typeof(int));
        }
        /// <remarks>
        ///  Returns if the document is empty.
        ///      </remarks>        <short>    Returns if the document is empty.</short>
        [SmokeMethod("isEmpty() const")]
        public virtual bool IsEmpty() {
            return (bool) interceptor.Invoke("isEmpty", "isEmpty() const", typeof(bool));
        }
        /// <remarks>
        ///  Get the length of a given line in characters.
        ///  \param line line to get length from
        ///  \return the number of characters in the line or -1 if the line was
        ///          invalid
        ///  \see line()
        ///      </remarks>        <short>    Get the length of a given line in characters.</short>
        [SmokeMethod("lineLength(int) const")]
        public virtual int LineLength(int line) {
            return (int) interceptor.Invoke("lineLength$", "lineLength(int) const", typeof(int), typeof(int), line);
        }
        /// <remarks>
        ///  Get the end cursor position of line <pre>line</pre>.
        ///  \param line line
        ///  \see lineLength(), line()
        ///      </remarks>        <short>    Get the end cursor position of line \p line.</short>
        public KTextEditor.Cursor EndOfLine(int line) {
            return (KTextEditor.Cursor) interceptor.Invoke("endOfLine$", "endOfLine(int) const", typeof(KTextEditor.Cursor), typeof(int), line);
        }
        /// <remarks>
        ///  Set the given text as new document content.
        ///  \param text new content for the document
        ///  \return \e true on success, otherwise \e false
        ///  \see text()
        ///      </remarks>        <short>    Set the given text as new document content.</short>
        [SmokeMethod("setText(const QString&)")]
        public virtual bool SetText(string text) {
            return (bool) interceptor.Invoke("setText$", "setText(const QString&)", typeof(bool), typeof(string), text);
        }
        /// <remarks>
        ///  Set the given text as new document content.
        ///  \param text new content for the document
        ///  \return \e true on success, otherwise \e false
        ///  \see text()
        ///      </remarks>        <short>    Set the given text as new document content.</short>
        [SmokeMethod("setText(const QStringList&)")]
        public virtual bool SetText(List<string> text) {
            return (bool) interceptor.Invoke("setText?", "setText(const QStringList&)", typeof(bool), typeof(List<string>), text);
        }
        /// <remarks>
        ///  Remove the whole content of the document.
        ///  \return \e true on success, otherwise \e false
        ///  \see removeText(), removeLine()
        ///      </remarks>        <short>    Remove the whole content of the document.</short>
        [SmokeMethod("clear()")]
        public virtual bool Clear() {
            return (bool) interceptor.Invoke("clear", "clear()", typeof(bool));
        }
        /// <remarks>
        ///  Insert <pre>text</pre> at <pre>position</pre>.
        ///  \param position position to insert the text
        ///  \param text text to insert
        ///  \param block insert this text as a visual block of text rather than a linear sequence
        ///  \return \e true on success, otherwise \e false
        ///  \see setText(), removeText()
        ///      </remarks>        <short>    Insert \p text at \p position.</short>
        [SmokeMethod("insertText(const KTextEditor::Cursor&, const QString&, bool)")]
        public virtual bool InsertText(KTextEditor.Cursor position, string text, bool block) {
            return (bool) interceptor.Invoke("insertText#$$", "insertText(const KTextEditor::Cursor&, const QString&, bool)", typeof(bool), typeof(KTextEditor.Cursor), position, typeof(string), text, typeof(bool), block);
        }
        [SmokeMethod("insertText(const KTextEditor::Cursor&, const QString&)")]
        public virtual bool InsertText(KTextEditor.Cursor position, string text) {
            return (bool) interceptor.Invoke("insertText#$", "insertText(const KTextEditor::Cursor&, const QString&)", typeof(bool), typeof(KTextEditor.Cursor), position, typeof(string), text);
        }
        /// <remarks>
        ///  Insert <pre>text</pre> at <pre>position</pre>.
        ///  \param position position to insert the text
        ///  \param text text to insert
        ///  \param block insert this text as a visual block of text rather than a linear sequence
        ///  \return \e true on success, otherwise \e false
        ///  \see setText(), removeText()
        ///      </remarks>        <short>    Insert \p text at \p position.</short>
        [SmokeMethod("insertText(const KTextEditor::Cursor&, const QStringList&, bool)")]
        public virtual bool InsertText(KTextEditor.Cursor position, List<string> text, bool block) {
            return (bool) interceptor.Invoke("insertText#?$", "insertText(const KTextEditor::Cursor&, const QStringList&, bool)", typeof(bool), typeof(KTextEditor.Cursor), position, typeof(List<string>), text, typeof(bool), block);
        }
        [SmokeMethod("insertText(const KTextEditor::Cursor&, const QStringList&)")]
        public virtual bool InsertText(KTextEditor.Cursor position, List<string> text) {
            return (bool) interceptor.Invoke("insertText#?", "insertText(const KTextEditor::Cursor&, const QStringList&)", typeof(bool), typeof(KTextEditor.Cursor), position, typeof(List<string>), text);
        }
        /// <remarks>
        ///  Replace text from <pre>range</pre> with specified <pre>text</pre>.
        ///  \param range range of text to replace
        ///  \param text text to replace with
        ///  \param block replace text as a visual block of text rather than a linear sequence
        ///  \return \e true on success, otherwise \e false
        ///  \see setText(), removeText(), insertText()
        ///      </remarks>        <short>    Replace text from \p range with specified \p text.</short>
        [SmokeMethod("replaceText(const KTextEditor::Range&, const QString&, bool)")]
        public virtual bool ReplaceText(KTextEditor.Range range, string text, bool block) {
            return (bool) interceptor.Invoke("replaceText#$$", "replaceText(const KTextEditor::Range&, const QString&, bool)", typeof(bool), typeof(KTextEditor.Range), range, typeof(string), text, typeof(bool), block);
        }
        [SmokeMethod("replaceText(const KTextEditor::Range&, const QString&)")]
        public virtual bool ReplaceText(KTextEditor.Range range, string text) {
            return (bool) interceptor.Invoke("replaceText#$", "replaceText(const KTextEditor::Range&, const QString&)", typeof(bool), typeof(KTextEditor.Range), range, typeof(string), text);
        }
        /// <remarks>
        ///  Replace text from <pre>range</pre> with specified <pre>text</pre>.
        ///  \param range range of text to replace
        ///  \param text text to replace with
        ///  \param block replace text as a visual block of text rather than a linear sequence
        ///  \return \e true on success, otherwise \e false
        ///  \see setText(), removeText(), insertText()
        ///      </remarks>        <short>    Replace text from \p range with specified \p text.</short>
        [SmokeMethod("replaceText(const KTextEditor::Range&, const QStringList&, bool)")]
        public virtual bool ReplaceText(KTextEditor.Range range, List<string> text, bool block) {
            return (bool) interceptor.Invoke("replaceText#?$", "replaceText(const KTextEditor::Range&, const QStringList&, bool)", typeof(bool), typeof(KTextEditor.Range), range, typeof(List<string>), text, typeof(bool), block);
        }
        [SmokeMethod("replaceText(const KTextEditor::Range&, const QStringList&)")]
        public virtual bool ReplaceText(KTextEditor.Range range, List<string> text) {
            return (bool) interceptor.Invoke("replaceText#?", "replaceText(const KTextEditor::Range&, const QStringList&)", typeof(bool), typeof(KTextEditor.Range), range, typeof(List<string>), text);
        }
        /// <remarks>
        ///  Remove the text specified in <pre>range</pre>.
        ///  \param range range of text to remove
        ///  \param block set this to true to remove a text block on the basis of columns, rather than everything inside <pre>range</pre>
        ///  \return \e true on success, otherwise \e false
        ///  \see setText(), insertText()
        ///      </remarks>        <short>    Remove the text specified in \p range.</short>
        [SmokeMethod("removeText(const KTextEditor::Range&, bool)")]
        public virtual bool RemoveText(KTextEditor.Range range, bool block) {
            return (bool) interceptor.Invoke("removeText#$", "removeText(const KTextEditor::Range&, bool)", typeof(bool), typeof(KTextEditor.Range), range, typeof(bool), block);
        }
        [SmokeMethod("removeText(const KTextEditor::Range&)")]
        public virtual bool RemoveText(KTextEditor.Range range) {
            return (bool) interceptor.Invoke("removeText#", "removeText(const KTextEditor::Range&)", typeof(bool), typeof(KTextEditor.Range), range);
        }
        /// <remarks>
        ///  Checks whether the <pre>cursor</pre> specifies a valid position in a document.
        ///  It can optionally be overridden by an implementation.
        ///  \param cursor which should be checked
        ///  \return \e true, if the cursor is valid, otherwise \e false
        ///  \see SmartCursor.IsValid()
        ///      </remarks>        <short>    Checks whether the \p cursor specifies a valid position in a document.</short>
        [SmokeMethod("cursorInText(const KTextEditor::Cursor&)")]
        public virtual bool CursorInText(KTextEditor.Cursor cursor) {
            return (bool) interceptor.Invoke("cursorInText#", "cursorInText(const KTextEditor::Cursor&)", typeof(bool), typeof(KTextEditor.Cursor), cursor);
        }
        /// <remarks>
        ///  Insert line(s) at the given line number. The newline character '\\n'
        ///  is treated as line delimiter, so it is possible to insert multiple
        ///  lines. To append lines at the end of the document, use
        ///  <pre>
        ///  insertLine( lines(), text )
        ///  </pre>
        ///  \param line line where to insert the text
        ///  \param text text which should be inserted
        ///  \return \e true on success, otherwise \e false
        ///  \see insertText()
        ///      </remarks>        <short>    Insert line(s) at the given line number.</short>
        [SmokeMethod("insertLine(int, const QString&)")]
        public virtual bool InsertLine(int line, string text) {
            return (bool) interceptor.Invoke("insertLine$$", "insertLine(int, const QString&)", typeof(bool), typeof(int), line, typeof(string), text);
        }
        /// <remarks>
        ///  Insert line(s) at the given line number. The newline character '\\n'
        ///  is treated as line delimiter, so it is possible to insert multiple
        ///  lines. To append lines at the end of the document, use
        ///  <pre>
        ///  insertLine( lines(), text )
        ///  </pre>
        ///  \param line line where to insert the text
        ///  \param text text which should be inserted
        ///  \return \e true on success, otherwise \e false
        ///  \see insertText()
        ///      </remarks>        <short>    Insert line(s) at the given line number.</short>
        [SmokeMethod("insertLines(int, const QStringList&)")]
        public virtual bool InsertLines(int line, List<string> text) {
            return (bool) interceptor.Invoke("insertLines$?", "insertLines(int, const QStringList&)", typeof(bool), typeof(int), line, typeof(List<string>), text);
        }
        /// <remarks>
        ///  Remove <pre>line</pre> from the document.
        ///  \param line line to remove
        ///  \return \e true on success, otherwise \e false
        ///  \see removeText(), clear()
        ///      </remarks>        <short>    Remove \p line from the document.</short>
        [SmokeMethod("removeLine(int)")]
        public virtual bool RemoveLine(int line) {
            return (bool) interceptor.Invoke("removeLine$", "removeLine(int)", typeof(bool), typeof(int), line);
        }
        /// <remarks>
        ///  Return the name of the currently used mode
        ///  \return name of the used mode
        ///  \see modes(), setMode()
        ///      </remarks>        <short>    Return the name of the currently used mode  \return name of the used mode  \see modes(), setMode()      </short>
        [SmokeMethod("mode() const")]
        public virtual string Mode() {
            return (string) interceptor.Invoke("mode", "mode() const", typeof(string));
        }
        /// <remarks>
        ///  Return the name of the currently used mode
        ///  \return name of the used mode
        ///  \see highlightingModes(), setHighlightingMode()
        ///      </remarks>        <short>    Return the name of the currently used mode  \return name of the used mode  \see highlightingModes(), setHighlightingMode()      </short>
        [SmokeMethod("highlightingMode() const")]
        public virtual string HighlightingMode() {
            return (string) interceptor.Invoke("highlightingMode", "highlightingMode() const", typeof(string));
        }
        /// <remarks>
        ///  Return a list of the names of all possible modes
        ///  \return list of mode names
        ///  \see mode(), setMode()
        ///      </remarks>        <short>    Return a list of the names of all possible modes  \return list of mode names  \see mode(), setMode()      </short>
        [SmokeMethod("modes() const")]
        public virtual List<string> Modes() {
            return (List<string>) interceptor.Invoke("modes", "modes() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Return a list of the names of all possible modes
        ///  \return list of mode names
        ///  \see highlightingMode(), setHighlightingMode()
        ///      </remarks>        <short>    Return a list of the names of all possible modes  \return list of mode names  \see highlightingMode(), setHighlightingMode()      </short>
        [SmokeMethod("highlightingModes() const")]
        public virtual List<string> HighlightingModes() {
            return (List<string>) interceptor.Invoke("highlightingModes", "highlightingModes() const", typeof(List<string>));
        }
        /// <remarks>
        ///  Set the current mode of the document by giving its name
        ///  \param name name of the mode to use for this document
        ///  \return \e true on success, otherwise \e false
        ///  \see mode(), modes(), modeChanged()
        ///      </remarks>        <short>    Set the current mode of the document by giving its name  \param name name of the mode to use for this document  \return \e true on success, otherwise \e false  \see mode(), modes(), modeChanged()      </short>
        [SmokeMethod("setMode(const QString&)")]
        public virtual bool SetMode(string name) {
            return (bool) interceptor.Invoke("setMode$", "setMode(const QString&)", typeof(bool), typeof(string), name);
        }
        /// <remarks>
        ///  Set the current mode of the document by giving its name
        ///  \param name name of the mode to use for this document
        ///  \return \e true on success, otherwise \e false
        ///  \see highlightingMode(), highlightingModes(), highlightingModeChanged()
        ///      </remarks>        <short>    Set the current mode of the document by giving its name  \param name name of the mode to use for this document  \return \e true on success, otherwise \e false  \see highlightingMode(), highlightingModes(), highlightingModeChanged()      </short>
        [SmokeMethod("setHighlightingMode(const QString&)")]
        public virtual bool SetHighlightingMode(string name) {
            return (bool) interceptor.Invoke("setHighlightingMode$", "setHighlightingMode(const QString&)", typeof(bool), typeof(string), name);
        }
        /// <remarks>
        ///  Returns the name of the section for a highlight given its index in the highlight
        ///  list (as returned by highlightModes()).
        ///  You can use this function to build a tree of the highlight names, organized in sections.
        ///  \param name the name of the highlight for which to find the section name.
        ///      </remarks>        <short>    Returns the name of the section for a highlight given its index in the highlight  list (as returned by highlightModes()).</short>
        [SmokeMethod("highlightingModeSection(int) const")]
        public virtual string HighlightingModeSection(int index) {
            return (string) interceptor.Invoke("highlightingModeSection$", "highlightingModeSection(int) const", typeof(string), typeof(int), index);
        }
        /// <remarks>
        ///  Returns the name of the section for a mode given its index in the highlight
        ///  list (as returned by modes()).
        ///  You can use this function to build a tree of the mode names, organized in sections.
        ///  \param name the name of the highlight for which to find the section name.
        ///      </remarks>        <short>    Returns the name of the section for a mode given its index in the highlight  list (as returned by modes()).</short>
        [SmokeMethod("modeSection(int) const")]
        public virtual string ModeSection(int index) {
            return (string) interceptor.Invoke("modeSection$", "modeSection(int) const", typeof(string), typeof(int), index);
        }
        /// <remarks>
        ///  by default dialogs should be displayed.
        ///  In any case (dialog shown or suppressed)
        ///  openingErrors and openingErrorMessage should have meaningfull values
        ///  \param suppress true/false value if dialogs should be displayed
        ///      </remarks>        <short>    by default dialogs should be displayed.</short>
        public void SetSuppressOpeningErrorDialogs(bool suppress) {
            interceptor.Invoke("setSuppressOpeningErrorDialogs$", "setSuppressOpeningErrorDialogs(bool)", typeof(void), typeof(bool), suppress);
        }
        public bool SuppressOpeningErrorDialogs() {
            return (bool) interceptor.Invoke("suppressOpeningErrorDialogs", "suppressOpeningErrorDialogs() const", typeof(bool));
        }
        /// <remarks>
        ///  True, eg if the file for opening could not be read
        ///  This doesn't have to handle the KPart job cancled cases
        ///      </remarks>        <short>    True, eg if the file for opening could not be read  This doesn't have to handle the KPart job cancled cases      </short>
        public bool OpeningError() {
            return (bool) interceptor.Invoke("openingError", "openingError() const", typeof(bool));
        }
        public string OpeningErrorMessage() {
            return (string) interceptor.Invoke("openingErrorMessage", "openingErrorMessage() const", typeof(string));
        }
        protected void SetOpeningError(bool errors) {
            interceptor.Invoke("setOpeningError$", "setOpeningError(bool)", typeof(void), typeof(bool), errors);
        }
        protected void SetOpeningErrorMessage(string message) {
            interceptor.Invoke("setOpeningErrorMessage$", "setOpeningErrorMessage(const QString&)", typeof(void), typeof(string), message);
        }
        ~Document() {
            interceptor.Invoke("~Document", "~Document()", typeof(void));
        }
        public new void Dispose() {
            interceptor.Invoke("~Document", "~Document()", typeof(void));
        }
        protected new IDocumentSignals Emit {
            get { return (IDocumentSignals) Q_EMIT; }
        }
    }

    public interface IDocumentSignals : KParts.IReadWritePartSignals {
        /// <remarks>
        ///  This signal is emitted whenever the <pre>document</pre> creates a new <pre>view</pre>.
        ///  It should be called for every view to help applications / plugins to
        ///  attach to the <pre>view</pre>.
        ///  \attention This signal should be emitted after the view constructor is
        ///             completed, e.g. in the createView() method.
        ///  \param document the document for which a new view is created
        ///  \param view the new view
        ///  \see createView()
        ///     </remarks>        <short>    This signal is emitted whenever the \p document creates a new \p view.</short>
        [Q_SIGNAL("void viewCreated(KTextEditor::Document*, KTextEditor::View*)")]
        void ViewCreated(KTextEditor.Document document, KTextEditor.View view);
        /// <remarks>
        ///  This signal is emitted whenever the <pre>document</pre> name changes.
        ///  \param document document which changed its name
        ///  \see documentName()
        ///      </remarks>        <short>    This signal is emitted whenever the \p document name changes.</short>
        [Q_SIGNAL("void documentNameChanged(KTextEditor::Document*)")]
        void DocumentNameChanged(KTextEditor.Document document);
        /// <remarks>
        ///  This signal is emitted whenever the <pre>document</pre> URL changes.
        ///  \param document document which changed its URL
        ///  \see KParts.ReadOnlyPart.Url()
        ///      </remarks>        <short>    This signal is emitted whenever the \p document URL changes.</short>
        [Q_SIGNAL("void documentUrlChanged(KTextEditor::Document*)")]
        void DocumentUrlChanged(KTextEditor.Document document);
        /// <remarks>
        ///  This signal is emitted whenever the <pre>document</pre>'s buffer changed from
        ///  either state \e unmodified to \e modified or vice versa.
        ///  \param document document which changed its modified state
        ///  \see KParts.ReadWritePart.IsModified().
        ///  \see KParts.ReadWritePart.SetModified()
        ///      </remarks>        <short>    This signal is emitted whenever the \p document's buffer changed from  either state \e unmodified to \e modified or vice versa.</short>
        [Q_SIGNAL("void modifiedChanged(KTextEditor::Document*)")]
        void ModifiedChanged(KTextEditor.Document document);
        /// <remarks>
        ///  The <pre>document</pre> emits this signal whenever its text changes.
        ///  \param document document which emitted this signal
        ///  \see text(), textLine()
        ///      </remarks>        <short>    The \p document emits this signal whenever its text changes.</short>
        [Q_SIGNAL("void textChanged(KTextEditor::Document*)")]
        void TextChanged(KTextEditor.Document document);
        /// <remarks>
        ///  The <pre>document</pre> emits this signal whenever text was inserted.  The
        ///  insertion occurred at range.start(), and new text now occupies up to
        ///  range.end().
        ///  \param document document which emitted this signal
        ///  \param range range that the newly inserted text occupies
        ///  \see insertText(), insertLine()
        ///      </remarks>        <short>    The \p document emits this signal whenever text was inserted.</short>
        [Q_SIGNAL("void textInserted(KTextEditor::Document*, KTextEditor::Range)")]
        void TextInserted(KTextEditor.Document document, KTextEditor.Range range);
        /// <remarks>
        ///  The <pre>document</pre> emits this signal whenever <pre>range</pre> was removed, i.e.
        ///  text was removed.
        ///  \param document document which emitted this signal
        ///  \param range range that the removed text previously occupied
        ///  \see removeText(), removeLine(), clear()
        ///      </remarks>        <short>    The \p document emits this signal whenever \p range was removed, i.</short>
        [Q_SIGNAL("void textRemoved(KTextEditor::Document*, KTextEditor::Range)")]
        void TextRemoved(KTextEditor.Document document, KTextEditor.Range range);
        /// <remarks>
        ///  The <pre>document</pre> emits this signal whenever the text in range
        ///  <pre>oldRange</pre> was removed and replaced with the text now in \e newRange,
        ///  e.g. the user selects text and pastes new text to replace the selection.
        ///  <b>Note:<> <pre>oldRange</pre>.start() is guaranteed to equal <pre>newRange</pre>.start().
        ///  \param document document which emitted this signal
        ///  \param oldRange range that the text previously occupied
        ///  \param newRange range that the changed text now occupies
        ///  \see insertText(), insertLine(), removeText(), removeLine(), clear()
        ///      </remarks>        <short>    The \p document emits this signal whenever the text in range  \p oldRange was removed and replaced with the text now in \e newRange,  e.</short>
        [Q_SIGNAL("void textChanged(KTextEditor::Document*, KTextEditor::Range, KTextEditor::Range)")]
        void TextChanged(KTextEditor.Document document, KTextEditor.Range oldRange, KTextEditor.Range newRange);
        /// <remarks>
        ///  Warn anyone listening that the current document is about to close.
        ///  At this point all of the information is still accessible, such as the text,
        ///  cursors and ranges.
        ///  Any modifications made to the document at this point will be lost.
        ///  \param document the document being closed
        ///      </remarks>        <short>    Warn anyone listening that the current document is about to close.</short>
        [Q_SIGNAL("void aboutToClose(KTextEditor::Document*)")]
        void AboutToClose(KTextEditor.Document document);
        /// <remarks>
        ///  Warn anyone listening that the current document is about to reload.
        ///  At this point all of the information is still accessible, such as the text,
        ///  cursors and ranges.
        ///  Any modifications made to the document at this point will be lost.
        ///  \param document the document being reloaded
        ///      </remarks>        <short>    Warn anyone listening that the current document is about to reload.</short>
        [Q_SIGNAL("void aboutToReload(KTextEditor::Document*)")]
        void AboutToReload(KTextEditor.Document document);
        /// <remarks>
        ///  Warn anyone listening that the current document's mode has
        ///  changed.
        ///  \param document the document whose mode has changed
        ///  \see setMode()
        ///      </remarks>        <short>    Warn anyone listening that the current document's mode has  changed.</short>
        [Q_SIGNAL("void modeChanged(KTextEditor::Document*)")]
        void ModeChanged(KTextEditor.Document document);
        /// <remarks>
        ///  Warn anyone listening that the current document's highlighting mode has
        ///  changed.
        ///  \param document the document which's mode has changed
        ///  \see setHighlightingMode()
        ///      </remarks>        <short>    Warn anyone listening that the current document's highlighting mode has  changed.</short>
        [Q_SIGNAL("void highlightingModeChanged(KTextEditor::Document*)")]
        void HighlightingModeChanged(KTextEditor.Document document);
    }
}
