//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  This class can be used as a base class for classes that want to show
    ///  a single item to the user and keep track of status changes of the item
    ///  without having to using a Monitor object themself.
    ///  Example:
    ///  @code
    ///  // A label that shows the name of a contact item
    ///  class ContactLabel : public QLabel, public Akonadi.ItemMonitor
    ///  {
    ///    public      ContactLabel( QWidget parent = 0 )
    ///      {
    ///        setText( "No Name" );
    ///      }
    ///    protected:
    ///      void itemChanged( const Akonadi.Item &item )
    ///      {
    ///        if ( item.mimeType() != "text/directory" )
    ///          return;
    ///        const KABC.Addressee addr = item.payload<KABC.Addressee>();
    ///        setText( addr.fullName() );
    ///      }
    ///      void itemRemoved()
    ///      {
    ///        setText( "No Name" );
    ///      }
    ///  }
    ///  ...
    ///  ContactLabel label = new ContactLabel( this );
    ///  const Akonadi.Item item = fetchJob.Items().first();
    ///  label.SetItem( item );
    ///  @endcode
    /// </remarks>        <author> Tobias Koenig <tokoe@kde.org>
    ///  </author>
    ///         <short> A convenience class to monitor a single item for changes. </short>
    [SmokeClass("Akonadi::ItemMonitor")]
    public class ItemMonitor : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected ItemMonitor(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(ItemMonitor), this);
        }
        /// <remarks>
        ///  Creates a new item monitor.
        ///      </remarks>        <short>    Creates a new item monitor.</short>
        public ItemMonitor() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ItemMonitor", "ItemMonitor()", typeof(void));
        }
        /// <remarks>
        ///  Sets the <code>item</code> that shall be monitored.
        ///      </remarks>        <short>    Sets the <code>item</code> that shall be monitored.</short>
        public void SetItem(Akonadi.Item item) {
            interceptor.Invoke("setItem#", "setItem(const Akonadi::Item&)", typeof(void), typeof(Akonadi.Item), item);
        }
        /// <remarks>
        ///  Returns the currently monitored item.
        ///      </remarks>        <short>    Returns the currently monitored item.</short>
        public Akonadi.Item Item() {
            return (Akonadi.Item) interceptor.Invoke("item", "item() const", typeof(Akonadi.Item));
        }
        /// <remarks>
        ///  This method is called whenever the monitored item has changed.
        /// <param> name="item" The changed item.
        ///      </param></remarks>        <short>    This method is called whenever the monitored item has changed.</short>
        [SmokeMethod("itemChanged(const Akonadi::Item&)")]
        protected virtual void ItemChanged(Akonadi.Item item) {
            interceptor.Invoke("itemChanged#", "itemChanged(const Akonadi::Item&)", typeof(void), typeof(Akonadi.Item), item);
        }
        /// <remarks>
        ///  This method is called whenever the monitored item has been removed.
        ///      </remarks>        <short>    This method is called whenever the monitored item has been removed.</short>
        [SmokeMethod("itemRemoved()")]
        protected virtual void ItemRemoved() {
            interceptor.Invoke("itemRemoved", "itemRemoved()", typeof(void));
        }
        /// <remarks>
        ///  Sets the item fetch scope.
        ///  Controls how much of an item's data is fetched from the server, e.g.
        ///  whether to fetch the full item payload or only meta data.
        /// <param> name="fetchScope" The new scope for item fetch operations.
        /// </param></remarks>        <short>    Sets the item fetch scope.</short>
        ///         <see> fetchScope</see>
        protected void SetFetchScope(Akonadi.ItemFetchScope fetchScope) {
            interceptor.Invoke("setFetchScope#", "setFetchScope(const Akonadi::ItemFetchScope&)", typeof(void), typeof(Akonadi.ItemFetchScope), fetchScope);
        }
        /// <remarks>
        ///  Returns the item fetch scope.
        ///  Since this returns a reference it can be used to conveniently modify the
        ///  current scope in-place, i.e. by calling a method on the returned reference
        ///  without storing it in a local variable. See the ItemFetchScope documentation
        ///  for an example.
        /// </remarks>        <return> a reference to the current item fetch scope
        /// </return>
        ///         <short>    Returns the item fetch scope.</short>
        ///         <see> setFetchScope</see>
        ///         <see> for</see>
        ///         <see> replacing</see>
        ///         <see> the</see>
        ///         <see> current</see>
        ///         <see> item</see>
        ///         <see> fetch</see>
        ///         <see> scope</see>
        protected Akonadi.ItemFetchScope FetchScope() {
            return (Akonadi.ItemFetchScope) interceptor.Invoke("fetchScope", "fetchScope()", typeof(Akonadi.ItemFetchScope));
        }
        ~ItemMonitor() {
            interceptor.Invoke("~ItemMonitor", "~ItemMonitor()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~ItemMonitor", "~ItemMonitor()", typeof(void));
        }
    }
}
