/*!
 * PHP-Qt - The PHP language bindings for Qt
 *
 * Copyright (C) 2006 - 2007
 * Thomas Moenicke <tm at php-qt.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 * QString.cpp - QString PHP implementation.
 * begin           : Wed Jan 18 23:31:01 2006
 * generated by    : moni using kalyptus 0.9.
 */

#include <QtCore/QDebug>
#include <QtCore/QString>

#include "pDebug.h"
#include "php_qt.h"
#include "zend_extension.h"
#include "phpqt_internals.h"
using namespace PHPQt;
#include "qstring.h"

zend_class_entry* qstring_ce;
extern Smoke* qt_Smoke;

static zend_function_entry QString_methods[] = {
	ZEND_ME(QString,__toString,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,compare,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,utf16,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,constData,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,insert,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,clear,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,setUtf16,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,prepend,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,trimmed,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,chop,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,leftJustified,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,squeeze,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,count,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,fromAscii,NULL,ZEND_ACC_PUBLIC|ZEND_ACC_STATIC)
	ZEND_ME(QString,toLongLong,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,toUpper,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString, __construct,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,normalized,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,fromUtf16,NULL,ZEND_ACC_PUBLIC|ZEND_ACC_STATIC)
	ZEND_ME(QString,isRightToLeft,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,setNum,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,endsWith,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,number,NULL,ZEND_ACC_PUBLIC|ZEND_ACC_STATIC)
	ZEND_ME(QString,localeAwareCompare,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,section,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,isSimpleText,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,size,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,simplified,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,toUInt,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,toUShort,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,truncate,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,toAscii,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,length,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,right,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,push_front,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,toUtf8,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,toULongLong,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,indexOf,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,fromRawData,NULL,ZEND_ACC_PUBLIC|ZEND_ACC_STATIC)
	ZEND_ME(QString,constEnd,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,left,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,fromLocal8Bit,NULL,ZEND_ACC_PUBLIC|ZEND_ACC_STATIC)
	ZEND_ME(QString,startsWith,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,remove,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,isEmpty,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,arg,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,vsprintf,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,toFloat,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,isDetached,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,reserve,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,toULong,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,toShort,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,split,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,setUnicode,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,fromLatin1,NULL,ZEND_ACC_PUBLIC|ZEND_ACC_STATIC)
	ZEND_ME(QString,data,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,toLatin1,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,end,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,contains,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,resize,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,replace,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,fromUtf8,NULL,ZEND_ACC_PUBLIC|ZEND_ACC_STATIC)
	ZEND_ME(QString,toLong,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,detach,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,append,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,mid,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,toDouble,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,fill,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,rightJustified,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,toLower,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,lastIndexOf,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,unicode,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,at,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,begin,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,push_back,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,capacity,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,constBegin,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,toLocal8Bit,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,toInt,NULL,ZEND_ACC_PUBLIC)
	ZEND_ME(QString,isNull,NULL,ZEND_ACC_PUBLIC)

    {NULL,NULL,NULL}
};

void _register_QString(TSRMLS_D)
{
    zend_class_entry ce;
    INIT_CLASS_ENTRY(ce,"QString",QString_methods);
    qstring_ce = zend_register_internal_class(&ce TSRMLS_CC);

}

extern "C" {

/*
 *	@return ZVAL_LONG
 */

ZEND_METHOD(QString,__toString){

  QString *QString_ptr = (QString *) PHP_QT_FETCH();
  zval* zstring = zstringFromQString(QString_ptr);
  ZVAL_ZVAL(return_value, zstring, 1, 0);
  efree(zstring);

  return;

}

/*		public enumSectionFlag:long {
			SectionDefault = 0x00,
			SectionSkipEmpty = 0x01,
			SectionIncludeLeadingSep = 0x02,
			SectionIncludeTrailingSep = 0x04,
			SectionCaseInsensitiveSeps = 0x08
		}
*/

/*		public enumSplitBehavior:long {
			SplitBehavior = 0,
			SplitBehavior = 1
		}
*/

/*		public enumNormalizationForm:long {
			NormalizationForm = 0,
			NormalizationForm = 1,
			NormalizationForm = 2,
			NormalizationForm = 3
		}
*/
/*********************************
 *    class     QString */
/*
 *    function  compare
 *    flags:    c
 */
ZEND_METHOD(QString, compare){

	if (ZEND_NUM_ARGS() == 1){
		/* o public*/

		/* const QString& s,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}

	if (ZEND_NUM_ARGS() == 2){
		/* oo public*/

		/* const QString& s1, const QString& s2,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);
			QObject* obj_z_1 = (QObject*) getQtObjectFromZval(z_1);


			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  utf16
 *    flags:    c
 */
ZEND_METHOD(QString, utf16){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
				const ushort * return_object = (const ushort *) obj->utf16();
				void* ptr = (void*) &return_object;
				createObject(return_value,(void*) return_object,qstring_ce, QSTRING_CLASSID);
				return;
	}
}

/*********************************
 *    class     QString */
/*
 *    function  constData
 *    flags:    c
 */
ZEND_METHOD(QString, constData){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
				const QChar * return_object = (const QChar *) obj->constData();


				createObject(return_value,(void*) return_object,qstring_ce, QSTRING_CLASSID);
				return;
	}
}

/*********************************
 *    class     QString */
/*
 *    function  insert
 *    flags:
 */
ZEND_METHOD(QString, insert){

	if (ZEND_NUM_ARGS() == 2){
		/* ll public*/

		/* int i, char c,  */
		/* lo public*/

		/* int i, const QString& s,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString & return_object = (QString &) obj->insert((int) Z_LVAL_P(z_0) ,(char) Z_LVAL_P(z_1));
				return_value = (zval*) emalloc(sizeof(zval));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_1 = (QObject*) getQtObjectFromZval(z_1);


			}
		}
	}

	if (ZEND_NUM_ARGS() == 3){
		/* lol public*/

		/* int i, const QChar* uc, int len,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		zval *z_2; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zzz", &z_0, &z_1, &z_2) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_OBJECT && Z_TYPE_P(z_2) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_1 = (QObject*) getQtObjectFromZval(z_1);


			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  clear
 *    flags:
 */
ZEND_METHOD(QString, clear){
	if (ZEND_NUM_ARGS() == 0){
	    QString *obj = (QString*) PHP_QT_FETCH();
	    obj->clear();
	    RETURN_NULL();
	}
	php_error(E_ERROR, "wrong argument in QString clear()");
}

/*********************************
 *    class     QString */
/*
 *    function  setUtf16
 *    flags:
 */
ZEND_METHOD(QString, setUtf16){

	if (ZEND_NUM_ARGS() == 2){
		/* ol public*/

		/* const ushort* utf16, int size,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString & return_object = (QString &) obj->setUtf16((const ushort*) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1));
				return_value = (zval*) emalloc(sizeof(zval));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  prepend
 *    flags:
 */
ZEND_METHOD(QString, prepend){

	if (ZEND_NUM_ARGS() == 1){
		/* l public*/

		/* char c,  */
		/* s public*/

		/* const char* s,  */
		/* o public*/

		/* const QString& s,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString & return_object = (QString &) obj->prepend((char) Z_LVAL_P(z_0));
				return_value = (zval*) emalloc(sizeof(zval));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
			if(Z_TYPE_P(z_0) == IS_STRING){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString & return_object = (QString &) obj->prepend( (const char*) Z_STRVAL_P(z_0));
				return_value = (zval*) emalloc(sizeof(zval));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
			if(Z_TYPE_P(z_0) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  trimmed
 *    flags:    c
 */
ZEND_METHOD(QString, trimmed){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->trimmed();
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
	}
}

/*********************************
 *    class     QString */
/*
 *    function  chop
 *    flags:
 */
ZEND_METHOD(QString, chop){

	if (ZEND_NUM_ARGS() == 1){
		/* l public*/

		/* int n,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			obj->chop((int) Z_LVAL_P(z_0));
			RETURN_NULL();
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  leftJustified
 *    flags:    c
 */
ZEND_METHOD(QString, leftJustified){

	if (ZEND_NUM_ARGS() == 3){
		/* lll public*/

		/* int width, char fill, int trunc,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		zval *z_2; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zzz", &z_0, &z_1, &z_2) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG){
				QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->leftJustified((int) Z_LVAL_P(z_0) ,(char) Z_LVAL_P(z_1) ,(bool) Z_LVAL_P(z_2));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  squeeze
 *    flags:
 */
ZEND_METHOD(QString, squeeze){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			obj->squeeze();
			RETURN_NULL();
	}
}

/*********************************
 *    class     QString */
/*
 *    function  count
 *    flags:    c
 */
ZEND_METHOD(QString, count){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			RETURN_LONG(obj->count());
	}

	if (ZEND_NUM_ARGS() == 1){
		/* o public*/

		/* const QRegExp& ,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}

	if (ZEND_NUM_ARGS() == 2){
		/* ol public*/

		/* const QString& s, int cs,  */
		/* ll public*/

		/* char c, int cs,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			RETURN_LONG(obj->count((char) Z_LVAL_P(z_0) ,(Qt::CaseSensitivity) Z_LVAL_P(z_1)));
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  fromAscii
 *    flags:    s
 */
ZEND_METHOD(QString, fromAscii){

	if (ZEND_NUM_ARGS() == 2){
		/* sl public*/

		/* const char* , int size,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_STRING && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->fromAscii( (const char*) Z_STRVAL_P(z_0) ,(int) Z_LVAL_P(z_1));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toLongLong
 *    flags:    c
 */
ZEND_METHOD(QString, toLongLong){

	if (ZEND_NUM_ARGS() == 2){
		/* ll public*/

		/* int* ok, int base,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			obj->toLongLong((bool*) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1));
			RETURN_NULL();
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toUpper
 *    flags:    c
 */
ZEND_METHOD(QString, toUpper){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->toUpper();
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
	}
}

/*********************************
 *    class     QString */
/*
 *    function  QString
 *    flags:
 */
ZEND_METHOD(QString, __construct)
{
	if (ZEND_NUM_ARGS() == 0){
		QString* QString_ptr = new QString();
		createObject(getThis(), (void*) QString_ptr, qstring_ce, QSTRING_CLASSID);
		RETURN_NULL();
	}

	if (ZEND_NUM_ARGS() == 1){
		zval* z_0; // define ZVAL
		if( zend_parse_parameters( ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0 ) == SUCCESS ) {

			if( Z_TYPE_P(z_0) == IS_LONG ) {
				QString *QString_ptr = new QString( (char) Z_LVAL_P(z_0) );
				PHPQt::createObject( getThis(), (void*) QString_ptr, qstring_ce, QSTRING_CLASSID );
				RETURN_NULL();

			} else if( Z_TYPE_P(z_0) == IS_STRING ){
				QString* QString_ptr = new QString( (const char*) Z_STRVAL_P(z_0));
				createObject(getThis(), (void*) QString_ptr, qstring_ce, QSTRING_CLASSID);
				RETURN_NULL();

			} else if( Z_TYPE_P(z_0) == IS_OBJECT ){
				smokephp_object* o = getSmokePHPObjectFromZval(z_0);
				if( o->ce_ptr() == qstring_ce )
					// copy constructor
					QString* QString_ptr = new QString( *((QString*) o->ptr()) );
				createObject( getThis(), o->ptr(), o->ce_ptr(), QSTRING_CLASSID );
				RETURN_NULL();
			}
		}
	}

	if (ZEND_NUM_ARGS() == 2){
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG){
			    smokephp_object* o = getSmokePHPObjectFromZval(z_0);
// TODO type checking
    			    createObject(getThis(), o->ptr(), o->ce_ptr());
			    RETURN_NULL();
			}
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			    QString *QString_ptr = new QString((int) Z_LVAL_P(z_0) ,(char) Z_LVAL_P(z_1));
			    createObject(getThis(), QString_ptr, qstring_ce, QSTRING_CLASSID);
			    RETURN_NULL();
			}
		}
	}
	if (ZEND_NUM_ARGS() > 2) {
	    php_error(E_ERROR, "Too many arguments in QString constructor\n");
	}
}

/*********************************
 *    class     QString */
/*
 *    function  normalized
 *    flags:    c
 */
ZEND_METHOD(QString, normalized){

	if (ZEND_NUM_ARGS() == 1){
		/* o public*/

		/* QString::NormalizationForm mode,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->normalized((QString::NormalizationForm) Z_LVAL_P(z_0));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}

	if (ZEND_NUM_ARGS() == 2){
		/* ol public*/

		/* QString::NormalizationForm mode, int version,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->normalized((QString::NormalizationForm) Z_LVAL_P(z_0) ,(QChar::UnicodeVersion) Z_LVAL_P(z_1));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  fromUtf16
 *    flags:    s
 */
ZEND_METHOD(QString, fromUtf16){

	if (ZEND_NUM_ARGS() == 2){
		/* ol public*/

		/* const ushort* , int size,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->fromUtf16((const ushort*) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  isRightToLeft
 *    flags:    c
 */
ZEND_METHOD(QString, isRightToLeft){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			RETURN_BOOL(obj->isRightToLeft());
	}
}

/*********************************
 *    class     QString */
/*
 *    function  setNum
 *    flags:
 */
ZEND_METHOD(QString, setNum){

	if (ZEND_NUM_ARGS() == 2){
		/* ol public*/

		/* short , int base,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString & return_object = (QString &) obj->setNum((short) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1));
				return_value = (zval*) emalloc(sizeof(zval));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}

	if (ZEND_NUM_ARGS() == 3){
		/* oll public*/

		/* float , char f, int prec,  */
		/* lll public*/

		/* double , char f, int prec,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		zval *z_2; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zzz", &z_0, &z_1, &z_2) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString & return_object = (QString &) obj->setNum((float) Z_LVAL_P(z_0) ,(char) Z_LVAL_P(z_1) ,(int) Z_LVAL_P(z_2));
				return_value = (zval*) emalloc(sizeof(zval));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString & return_object = (QString &) obj->setNum((double) Z_LVAL_P(z_0) ,(char) Z_LVAL_P(z_1) ,(int) Z_LVAL_P(z_2));
				return_value = (zval*) emalloc(sizeof(zval));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  endsWith
 *    flags:    c
 */
ZEND_METHOD(QString, endsWith){

	if (ZEND_NUM_ARGS() == 2){
		/* ol public*/

		/* const QString& s, int cs,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  number
 *    flags:    s
 *
 *	QString number ( long n, int base = 10 )
 *	QString number ( ulong n, int base = 10 )
 *	QString number ( int n, int base = 10 )
 *	QString number ( uint n, int base = 10 )
 *	QString number ( qlonglong n, int base = 10 )
 *	QString number ( qulonglong n, int base = 10 )
 *	QString number ( double n, char format = 'g', int precision = 6 )
 */
ZEND_METHOD(QString, number){

	if (ZEND_NUM_ARGS() == 1){
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG){
				QString obj = (QString) QString::number((ulong) Z_LVAL_P(z_0));
				QString *s1 = new QString(obj);

				createObject(return_value, (void*) s1, qstring_ce, QSTRING_CLASSID);
				return;
			} else if(Z_TYPE_P(z_0) == IS_DOUBLE){
				QString obj = (QString) QString::number((double) Z_DVAL_P(z_0));
				QString *s1 = new QString(obj);

				createObject(return_value, (void*) s1, qstring_ce, QSTRING_CLASSID);
				return;
			}

		}
	}

	if (ZEND_NUM_ARGS() == 2){
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->number((ulong) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->number((int) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}

	if (ZEND_NUM_ARGS() == 3){
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		zval *z_2; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zzz", &z_0, &z_1, &z_2) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->number((double) Z_LVAL_P(z_0) ,(char) Z_LVAL_P(z_1) ,(int) Z_LVAL_P(z_2));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
	php_error(E_ERROR, "wrong argument in QString::number()");
}

/*********************************
 *    class     QString */
/*
 *    function  localeAwareCompare
 *    flags:    c
 */
ZEND_METHOD(QString, localeAwareCompare){

	if (ZEND_NUM_ARGS() == 1){
		/* o public*/

		/* const QString& s,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}

	if (ZEND_NUM_ARGS() == 2){
		/* oo public*/

		/* const QString& s1, const QString& s2,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);
			QObject* obj_z_1 = (QObject*) getQtObjectFromZval(z_1);


			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  section
 *    flags:    c
 */
ZEND_METHOD(QString, section){

	if (ZEND_NUM_ARGS() == 4){
		/* lllo public*/

		/* char sep, int start, int end, QString::SectionFlags flags,  */
		/* ollo public*/

		/* const QString& in_sep, int start, int end, QString::SectionFlags flags,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		zval *z_2; // define ZVAL
		zval *z_3; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zzzz", &z_0, &z_1, &z_2, &z_3) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG && Z_TYPE_P(z_3) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->section((char) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1) ,(int) Z_LVAL_P(z_2) ,(QString::SectionFlags) Z_LVAL_P(z_3));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG && Z_TYPE_P(z_3) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  isSimpleText
 *    flags:    c
 */
ZEND_METHOD(QString, isSimpleText){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			RETURN_BOOL(obj->isSimpleText());
	}
}

/*********************************
 *    class     QString */
/*
 *    function  size
 *    flags:    c
 */
ZEND_METHOD(QString, size){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			RETURN_LONG(obj->size());
	}
}

/*********************************
 *    class     QString */
/*
 *    function  simplified
 *    flags:    c
 */
ZEND_METHOD(QString, simplified){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->simplified();
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toUInt
 *    flags:    c
 */
ZEND_METHOD(QString, toUInt){

	if (ZEND_NUM_ARGS() == 2){
		/* ll public*/

		/* int* ok, int base,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			RETURN_LONG(obj->toUInt((bool*) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1)));
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toUShort
 *    flags:    c
 */
ZEND_METHOD(QString, toUShort){

	if (ZEND_NUM_ARGS() == 2){
		/* ll public*/

		/* int* ok, int base,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			RETURN_LONG(obj->toUShort((bool*) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1)));
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  truncate
 *    flags:
 */
ZEND_METHOD(QString, truncate){

	if (ZEND_NUM_ARGS() == 1){
		/* l public*/

		/* int pos,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			obj->truncate((int) Z_LVAL_P(z_0));
			RETURN_NULL();
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toAscii
 *    flags:    c
 */
ZEND_METHOD(QString, toAscii){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
//			smokephp_object* o = PHP_QT_FETCH();
//			QString *obj = (QString*) o->ptr();
			RETURN_STRING((char*) obj->toAscii().constData(), 1);
	}
}

/*********************************
 *    class     QString */
/*
 *    function  length
 *    flags:    c
 */
ZEND_METHOD(QString, length){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			RETURN_LONG(obj->length());
	}
}

/*********************************
 *    class     QString */
/*
 *    function  right
 *    flags:    c
 */
ZEND_METHOD(QString, right){

	if (ZEND_NUM_ARGS() == 1){
		/* l public*/

		/* int len,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->right((int) Z_LVAL_P(z_0));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  push_front
 *    flags:
 */
ZEND_METHOD(QString, push_front){

	if (ZEND_NUM_ARGS() == 1){
		/* l public*/

		/* char c,  */
		/* o public*/

		/* const QString& s,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			obj->push_front((char) Z_LVAL_P(z_0));
			RETURN_NULL();
			}
			if(Z_TYPE_P(z_0) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toUtf8
 *    flags:    c
 */
ZEND_METHOD(QString, toUtf8){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			RETURN_STRING((char*) obj->toUtf8().constData(), 1);
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toULongLong
 *    flags:    c
 */
ZEND_METHOD(QString, toULongLong){

	if (ZEND_NUM_ARGS() == 2){
		/* ll public*/

		/* int* ok, int base,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			obj->toULongLong((bool*) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1));
			RETURN_NULL();
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  indexOf
 *    flags:    c
 */
ZEND_METHOD(QString, indexOf){

	if (ZEND_NUM_ARGS() == 2){
		/* ol public*/

		/* const QRegExp& , int from,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}

	if (ZEND_NUM_ARGS() == 3){
		/* oll public*/

		/* const QString& s, int from, int cs,  */
		/* lll public*/

		/* char c, int from, int cs,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		zval *z_2; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zzz", &z_0, &z_1, &z_2) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			RETURN_LONG(obj->indexOf((char) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1) ,(Qt::CaseSensitivity) Z_LVAL_P(z_2)));
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  fromRawData
 *    flags:    s
 */
ZEND_METHOD(QString, fromRawData){

	if (ZEND_NUM_ARGS() == 2){
		/* ol public*/

		/* const QChar* , int size,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  constEnd
 *    flags:    c
 */
ZEND_METHOD(QString, constEnd){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			obj->constEnd();
			RETURN_NULL();
	}
}

/*********************************
 *    class     QString */
/*
 *    function  left
 *    flags:    c
 */
ZEND_METHOD(QString, left){

	if (ZEND_NUM_ARGS() == 1){
		/* l public*/

		/* int len,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->left((int) Z_LVAL_P(z_0));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  fromLocal8Bit
 *    flags:    s
 */
ZEND_METHOD(QString, fromLocal8Bit){

	if (ZEND_NUM_ARGS() == 2){
		/* sl public*/

		/* const char* , int size,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_STRING && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->fromLocal8Bit( (const char*) Z_STRVAL_P(z_0) ,(int) Z_LVAL_P(z_1));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  startsWith
 *    flags:    c
 */
ZEND_METHOD(QString, startsWith){

	if (ZEND_NUM_ARGS() == 2){
		/* ol public*/

		/* const QString& s, int cs,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  remove
 *    flags:
 */
ZEND_METHOD(QString, remove){

	if (ZEND_NUM_ARGS() == 1){
		/* o public*/

		/* const QRegExp& rx,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}

	if (ZEND_NUM_ARGS() == 2){
		/* ol public*/

		/* const QString& s, int cs,  */
		/* ll public*/

		/* int i, int len,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString & return_object = (QString &) obj->remove((int) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1));
				return_value = (zval*) emalloc(sizeof(zval));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  isEmpty
 *    flags:    c
 */
ZEND_METHOD(QString, isEmpty){
	if (ZEND_NUM_ARGS() == 0){
	    QString *obj = (QString*) PHP_QT_FETCH();
	    RETURN_BOOL(obj->isEmpty());
	}
	php_error(E_ERROR, "wrong argument in QString isEmpty()");
}

/*********************************
 *    class     QString */
/*
 *    function  arg
 *    flags:    c
 */
ZEND_METHOD(QString, arg){

	/*
	 * - takes one argument and returns a QString on the stack
	 * - The argument can be of any primitive type or QString
	 * - NULL will be considered as an empty string
	 * - BOOL will be appended as the strings "TRUE" and "FALSE", which is usefull for debugging but 
	 *   should probably not be used in production.
	 * - non-QString objects are tried to be converted using the __toString() magic method
	 */
	
	if (ZEND_NUM_ARGS() == 1){
		zval *z_arg_0; // the argument
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_arg_0) == SUCCESS) {
			QString obj_z_0;
			QString *this_obj = (QString*) PHP_QT_FETCH(); // this

			if( Z_TYPE_P(z_arg_0) == IS_OBJECT ) {
				smokephp_object* o = getSmokePHPObjectFromZval( z_arg_0 );
				if( o &&  o->classId() == QSTRING_CLASSID ) {
					obj_z_0.append( *(QString*) getQtObjectFromZval(z_arg_0) );
				// try to convert it
				} else {
					z_arg_0 = PHPQt::callPHPMethod( z_arg_0, "__toString", 0, 0 );
					obj_z_0.append( Z_STRVAL_P( z_arg_0 ) );
				}

			} else if ( Z_TYPE_P(z_arg_0) == IS_NULL ) {
				obj_z_0.append( "" );
			} else if ( Z_TYPE_P(z_arg_0) == IS_BOOL ) {
				if( Z_BVAL_P(z_arg_0) )
					obj_z_0.append( "TRUE" );
				else
					obj_z_0.append( "FALSE" );
			} else if ( Z_TYPE_P(z_arg_0) == IS_STRING ) {
				obj_z_0.append( Z_STRVAL_P( z_arg_0 ) );
			} else if ( Z_TYPE_P(z_arg_0) == IS_LONG ) {
				obj_z_0.setNum( (int) Z_LVAL_P( z_arg_0 ) );
			} else if ( Z_TYPE_P(z_arg_0) == IS_DOUBLE ) {
				obj_z_0.setNum( (int) Z_DVAL_P( z_arg_0 ) );
			} else if ( ( Z_TYPE_P(z_arg_0) == IS_ARRAY || Z_TYPE_P(z_arg_0) == IS_RESOURCE ) ) {
				pError() << "Arrays or resources are not allowed as arguments for QString::arg()";
			}

			QString* return_object = new QString( this_obj->arg( obj_z_0 ) );
			createObject( return_value, (void*) return_object, qstring_ce, QSTRING_CLASSID );
			RETVAL_ZVAL( return_value, 0, 0 );
			return;
		}
	}

	if (ZEND_NUM_ARGS() == 2){
		/* oo public*/

		/* const QString& a1, const QString& a2,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);
			QObject* obj_z_1 = (QObject*) getQtObjectFromZval(z_1);


			}
		}
	}

	if (ZEND_NUM_ARGS() == 3){
		/* ooo public*/

		/* const QString& a1, const QString& a2, const QString& a3,  */
		/* olo public*/

		/* const QString& a, int fieldWidth, const QChar& fillChar,  */
		/* llo public*/

		/* char a, int fieldWidth, const QChar& fillChar,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		zval *z_2; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zzz", &z_0, &z_1, &z_2) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_OBJECT && Z_TYPE_P(z_2) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);
			QObject* obj_z_1 = (QObject*) getQtObjectFromZval(z_1);
			QObject* obj_z_2 = (QObject*) getQtObjectFromZval(z_2);


			}
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);
			QObject* obj_z_2 = (QObject*) getQtObjectFromZval(z_2);


			}
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_2 = (QObject*) getQtObjectFromZval(z_2);


			}
		}
	}

	if (ZEND_NUM_ARGS() == 4){
		/* lllo public*/

		/* int a, int fieldWidth, int base, const QChar& fillChar,  */
		/* ollo public*/

		/* qlonglong a, int fieldwidth, int base, const QChar& fillChar,  */
		/* oooo public*/

		/* const QString& a1, const QString& a2, const QString& a3, const QString& a4,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		zval *z_2; // define ZVAL
		zval *z_3; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zzzz", &z_0, &z_1, &z_2, &z_3) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG && Z_TYPE_P(z_3) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_3 = (QObject*) getQtObjectFromZval(z_3);


			}
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG && Z_TYPE_P(z_3) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_3 = (QObject*) getQtObjectFromZval(z_3);


			}
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_OBJECT && Z_TYPE_P(z_2) == IS_OBJECT && Z_TYPE_P(z_3) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);
			QObject* obj_z_1 = (QObject*) getQtObjectFromZval(z_1);
			QObject* obj_z_2 = (QObject*) getQtObjectFromZval(z_2);
			QObject* obj_z_3 = (QObject*) getQtObjectFromZval(z_3);


			}
		}
	}

	if (ZEND_NUM_ARGS() == 5){
		/* llllo public*/

		/* double a, int fieldWidth, char fmt, int prec, const QChar& fillChar,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		zval *z_2; // define ZVAL
		zval *z_3; // define ZVAL
		zval *z_4; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zzzzz", &z_0, &z_1, &z_2, &z_3, &z_4) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG && Z_TYPE_P(z_3) == IS_LONG && Z_TYPE_P(z_4) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_4 = (QObject*) getQtObjectFromZval(z_4);


			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  vsprintf
 *    flags:
 */
ZEND_METHOD(QString, vsprintf){

	if (ZEND_NUM_ARGS() == 2){
		/* so public*/

		/* const char* format, va_list ap,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_STRING && Z_TYPE_P(z_1) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_1 = (QObject*) getQtObjectFromZval(z_1);


			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toFloat
 *    flags:    c
 */
ZEND_METHOD(QString, toFloat){

	if (ZEND_NUM_ARGS() == 1){
		/* l public*/

		/* int* ok,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


//			RETURN_FLOAT(obj->toFloat((bool*) Z_LVAL_P(z_0)));
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  isDetached
 *    flags:    c
 */
ZEND_METHOD(QString, isDetached){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			RETURN_BOOL(obj->isDetached());
	}
}

/*********************************
 *    class     QString */
/*
 *    function  reserve
 *    flags:
 */
ZEND_METHOD(QString, reserve){

	if (ZEND_NUM_ARGS() == 1){
		/* l public*/

		/* int size,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			obj->reserve((int) Z_LVAL_P(z_0));
			RETURN_NULL();
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toULong
 *    flags:    c
 */
ZEND_METHOD(QString, toULong){

	if (ZEND_NUM_ARGS() == 2){
		/* ll public*/

		/* int* ok, int base,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
//			QString *obj = (QString*) PHP_QT_FETCH();


//			RETURN_ULONG(obj->toULong((bool*) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1)));
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toShort
 *    flags:    c
 */
ZEND_METHOD(QString, toShort){

	if (ZEND_NUM_ARGS() == 2){
		/* ll public*/

		/* int* ok, int base,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
//			QString *obj = (QString*) PHP_QT_FETCH();


//			RETURN_SHORT(obj->toShort((bool*) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1)));
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  split
 *    flags:    c
 */
ZEND_METHOD(QString, split){

	if (ZEND_NUM_ARGS() == 2){
		/* oo public*/

		/* const QRegExp& sep, QString::SplitBehavior behavior,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}

	if (ZEND_NUM_ARGS() == 3){
		/* ool public*/

		/* const QString& sep, QString::SplitBehavior behavior, int cs,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		zval *z_2; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zzz", &z_0, &z_1, &z_2) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  setUnicode
 *    flags:
 */
ZEND_METHOD(QString, setUnicode){

	if (ZEND_NUM_ARGS() == 2){
		/* ol public*/

		/* const QChar* unicode, int size,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  fromLatin1
 *    flags:    s
 */
ZEND_METHOD(QString, fromLatin1){

	if (ZEND_NUM_ARGS() == 2){
		/* sl public*/

		/* const char* , int size,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_STRING && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->fromLatin1( (const char*) Z_STRVAL_P(z_0) ,(int) Z_LVAL_P(z_1));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  data
 *    flags:
 */
ZEND_METHOD(QString, data){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
				QChar * return_object = (QChar *) obj->data();
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toLatin1
 *    flags:    c
 */
ZEND_METHOD(QString, toLatin1){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			RETURN_STRING((char*) obj->toLatin1().constData(), 1);
	}
}

/*********************************
 *    class     QString */
/*
 *    function  end
 *    flags:
 */
ZEND_METHOD(QString, end){
	if (ZEND_NUM_ARGS() == 0){
//			QString *obj = (QString*) PHP_QT_FETCH();
//			RETURN_INTPTR(obj->end());
	}
}

/*********************************
 *    class     QString */
/*
 *    function  contains
 *    flags:    c
 */
ZEND_METHOD(QString, contains){

	if (ZEND_NUM_ARGS() == 1){
		/* o public*/

		/* const QRegExp& rx,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}

	if (ZEND_NUM_ARGS() == 2){
		/* ol public*/

		/* const QString& s, int cs,  */
		/* ll public*/

		/* char c, int cs,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			obj->contains((char) Z_LVAL_P(z_0) ,(Qt::CaseSensitivity) Z_LVAL_P(z_1));
			RETURN_NULL();
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  resize
 *    flags:
 */
ZEND_METHOD(QString, resize){

	if (ZEND_NUM_ARGS() == 1){
		/* l public*/

		/* int size,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			obj->resize((int) Z_LVAL_P(z_0));
			RETURN_NULL();
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  replace
 *    flags:
 */
ZEND_METHOD(QString, replace){

	if (ZEND_NUM_ARGS() == 2){
		/* oo public*/

		/* const QRegExp& rx, const QString& after,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);
			QObject* obj_z_1 = (QObject*) getQtObjectFromZval(z_1);


			}
		}
	}

	if (ZEND_NUM_ARGS() == 3){
		/* ool public*/

		/* const QString& before, const QString& after, int cs,  */
		/* lol public*/

		/* char c, const QString& after, int cs,  */
		/* lll public*/

		/* int i, int len, char after,  */
		/* llo public*/

		/* int i, int len, const QString& after,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		zval *z_2; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zzz", &z_0, &z_1, &z_2) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_OBJECT && Z_TYPE_P(z_2) == IS_LONG)
			{
				QString *obj = (QString*) PHP_QT_FETCH();
				QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);
				QObject* obj_z_1 = (QObject*) getQtObjectFromZval(z_1);
			}
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_OBJECT && Z_TYPE_P(z_2) == IS_LONG)
			{
				QString *obj = (QString*) PHP_QT_FETCH();
				QObject* obj_z_1 = (QObject*) getQtObjectFromZval(z_1);
			}
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG)
			{
				QString *obj = (QString*) PHP_QT_FETCH();
				QString & return_object = (QString &) obj->replace((int) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1) ,(char) Z_LVAL_P(z_2));
				return_value = (zval*) emalloc(sizeof(zval));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_OBJECT){
				QString *obj = (QString*) PHP_QT_FETCH();
				QObject* obj_z_2 = (QObject*) getQtObjectFromZval(z_2);
			}
		}
	}

	if (ZEND_NUM_ARGS() == 4){
		/* llol public*/

		/* int i, int len, const QChar* s, int slen,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		zval *z_2; // define ZVAL
		zval *z_3; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zzzz", &z_0, &z_1, &z_2, &z_3) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_OBJECT && Z_TYPE_P(z_3) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_2 = (QObject*) getQtObjectFromZval(z_2);


			}
		}
	}
}

/*!
 *    class     QString 
 *
 *    function  fromUtf8
 *    flags:    s
 */
ZEND_METHOD(QString, fromUtf8)
{
    if (ZEND_NUM_ARGS() == 2)
    {
	zval *z_0; // define ZVAL
	zval *z_1; // define ZVAL
	if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) 
	{
	    if(Z_TYPE_P(z_0) == IS_STRING && Z_TYPE_P(z_1) == IS_LONG)
	    {
		if(getThis() == NULL)
		{
		    QString *s1 = new QString( QString::fromUtf8( Z_STRVAL_P(z_0) , static_cast<int>(Z_LVAL_P(z_1)) ) );
		    createObject(return_value, (void*) s1, qstring_ce, QSTRING_CLASSID);
		    return;
		}
	    }
	}
    }
    if (ZEND_NUM_ARGS() == 1)
    {
	zval *z_0; // define ZVAL
	if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) 
	{
	    if(Z_TYPE_P(z_0) == IS_STRING)
	    {
		if(getThis() == NULL)
		{
		    QString *s1 = new QString( QString::fromUtf8( Z_STRVAL_P(z_0) ) );
		    createObject(return_value, reinterpret_cast<void*>(s1), qstring_ce, QSTRING_CLASSID);
		    return;
		}
	    }
	}
    }
}

/*********************************
 *    class     QString */
/*
 *    function  toLong
 *    flags:    c
 */
ZEND_METHOD(QString, toLong){

	if (ZEND_NUM_ARGS() == 2){
		/* ll public*/

		/* int* ok, int base,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			RETURN_LONG(obj->toLong((bool*) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1)));
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  detach
 *    flags:
 */
ZEND_METHOD(QString, detach){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			obj->detach();
			RETURN_NULL();
	}
}

/*********************************
 *    class     QString */
/*
 *    function  append
 *    flags:
 */
ZEND_METHOD(QString, append){

	if (ZEND_NUM_ARGS() == 1){
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			/* QString & append ( QChar ch ) */
			if(Z_TYPE_P(z_0) == IS_LONG)
			{
				QString *obj = (QString*) PHP_QT_FETCH();
				QString & return_object = (QString &) obj->append((char) Z_LVAL_P(z_0));
				return_value = (zval*) emalloc(sizeof(zval));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
			/* QString & append ( const char * str ) */
			if(Z_TYPE_P(z_0) == IS_STRING)
			{
				QString *obj = (QString*) PHP_QT_FETCH();
				QString & return_object = (QString&) obj->append( (const char*) Z_STRVAL_P(z_0) );
				return_value = (zval*) emalloc(sizeof(zval));
 				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}

			/*  QString & append ( const QLatin1String & str )
			    QString & append ( const QByteArray & ba )
			    QString & append ( const QString & str ) */
			if(Z_TYPE_P(z_0) == IS_OBJECT){
			    smokephp_object* o = getSmokePHPObjectFromZval(getThis());
			    QString* obj_z_0 = (QString*) getQtObjectFromZval(z_0);
			    QString* s = new QString(((QString*) o->ptr())->append((QString) *obj_z_0));
			    createObject(return_value, s, qstring_ce, QSTRING_CLASSID);
			    return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  mid
 *    flags:    c
 */
ZEND_METHOD(QString, mid){

	if (ZEND_NUM_ARGS() == 2){
		/* ll public*/

		/* int i, int len,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG)
			{
				QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->mid((int) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toDouble
 *    flags:    c
 */
ZEND_METHOD(QString, toDouble){

	/* double toDouble ( bool * ok = 0 ) const */
	if (ZEND_NUM_ARGS() == 1){
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG){
			    QString *obj = (QString*) PHP_QT_FETCH();
			    RETURN_DOUBLE(obj->toDouble((bool*) Z_LVAL_P(z_0)));
			}
		}
	}
	if(ZEND_NUM_ARGS() == 0) {
	    QString *obj = (QString*) PHP_QT_FETCH();
	    RETURN_DOUBLE(obj->toDouble());
	}
	php_error(E_ERROR, "wrong argument in QString toDouble()");

}

/*********************************
 *    class     QString */
/*
 *    function  fill
 *    flags:
 */
ZEND_METHOD(QString, fill){

	if (ZEND_NUM_ARGS() == 2){
		/* ll public*/

		/* char c, int size,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG)
			{
				QString *obj = (QString*) PHP_QT_FETCH();
				QString & return_object = (QString &) obj->fill((char) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1));
				return_value = (zval*) emalloc(sizeof(zval));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  rightJustified
 *    flags:    c
 */
ZEND_METHOD(QString, rightJustified){

	if (ZEND_NUM_ARGS() == 3){
		/* lll public*/

		/* int width, char fill, int trunc,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		zval *z_2; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zzz", &z_0, &z_1, &z_2) == SUCCESS)
		{
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG)
			{
				QString *obj = (QString*) PHP_QT_FETCH();
				QString return_object = (QString) obj->rightJustified((int) Z_LVAL_P(z_0) ,(char) Z_LVAL_P(z_1) ,(bool) Z_LVAL_P(z_2));
				createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
				return;
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toLower
 *    flags:    c
 */
ZEND_METHOD(QString, toLower)
{
	if (ZEND_NUM_ARGS() == 0)
	{
		QString *obj = (QString*) PHP_QT_FETCH();
		QString return_object = (QString) obj->toLower();
		createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
		return;
	}
}

/*********************************
 *    class     QString */
/*
 *    function  lastIndexOf
 *    flags:    c
 */
ZEND_METHOD(QString, lastIndexOf){

	if (ZEND_NUM_ARGS() == 2){
		/* ol public*/

		/* const QRegExp& , int from,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}

	if (ZEND_NUM_ARGS() == 3){
		/* oll public*/

		/* const QString& s, int from, int cs,  */
		/* lll public*/

		/* char c, int from, int cs,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		zval *z_2; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zzz", &z_0, &z_1, &z_2) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_OBJECT && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG && Z_TYPE_P(z_2) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			RETURN_LONG(obj->lastIndexOf((char) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1) ,(Qt::CaseSensitivity) Z_LVAL_P(z_2)));
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  unicode
 *    flags:    c
 */
ZEND_METHOD(QString, unicode)
{
	if (ZEND_NUM_ARGS() == 0)
	{
		QString *obj = (QString*) PHP_QT_FETCH();
		const QChar * return_object = (const QChar *) obj->unicode();
		createObject(return_value,(void*) &return_object,qstring_ce, QSTRING_CLASSID);
		return;
	}
}

/*********************************
 *    class     QString */
/*
 *    function  at
 *    flags:    c
 */
ZEND_METHOD(QString, at){

	if (ZEND_NUM_ARGS() == 1){
		/* l public*/

		/* int i,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			obj->at((int) Z_LVAL_P(z_0));
			RETURN_NULL();
			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  begin
 *    flags:
 */
ZEND_METHOD(QString, begin){
	if (ZEND_NUM_ARGS() == 0){
//			QString *obj = (QString*) PHP_QT_FETCH();
//			RETURN_INTPTR(obj->begin());
	}
}

/*********************************
 *    class     QString */
/*
 *    function  push_back
 *    flags:
 */
ZEND_METHOD(QString, push_back){

	if (ZEND_NUM_ARGS() == 1){
		/* l public*/

		/* char c,  */
		/* o public*/

		/* const QString& s,  */
		zval *z_0; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"z", &z_0) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();


			obj->push_back((char) Z_LVAL_P(z_0));
			RETURN_NULL();
			}
			if(Z_TYPE_P(z_0) == IS_OBJECT){
			QString *obj = (QString*) PHP_QT_FETCH();
			QObject* obj_z_0 = (QObject*) getQtObjectFromZval(z_0);


			}
		}
	}
}

/*********************************
 *    class     QString */
/*
 *    function  capacity
 *    flags:    c
 */
ZEND_METHOD(QString, capacity){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			RETURN_LONG(obj->capacity());
	}
}

/*********************************
 *    class     QString */
/*
 *    function  constBegin
 *    flags:    c
 */
ZEND_METHOD(QString, constBegin){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			obj->constBegin();
			RETURN_NULL();
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toLocal8Bit
 *    flags:    c
 */
ZEND_METHOD(QString, toLocal8Bit){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			RETURN_STRING((char*) obj->toLocal8Bit().constData(), 1);
	}
}

/*********************************
 *    class     QString */
/*
 *    function  toInt
 *    flags:    c
 */
ZEND_METHOD(QString, toInt){

	if (ZEND_NUM_ARGS() == 2){
		/* ll public*/

		/* int* ok, int base,  */
		zval *z_0; // define ZVAL
		zval *z_1; // define ZVAL
		if(zend_parse_parameters(ZEND_NUM_ARGS() TSRMLS_CC,"zz", &z_0, &z_1) == SUCCESS) {
			if(Z_TYPE_P(z_0) == IS_LONG && Z_TYPE_P(z_1) == IS_LONG){
			QString *obj = (QString*) PHP_QT_FETCH();
			RETURN_LONG(obj->toInt((bool*) Z_LVAL_P(z_0) ,(int) Z_LVAL_P(z_1)));
			}
		}
	}

	if (ZEND_NUM_ARGS() == 0){
	    QString *obj = (QString*) PHP_QT_FETCH();
	    RETURN_LONG(obj->toInt());
	}

}

/*********************************
 *    class     QString */
/*
 *    function  isNull
 *    flags:    c
 */
ZEND_METHOD(QString, isNull){
	if (ZEND_NUM_ARGS() == 0){
			QString *obj = (QString*) PHP_QT_FETCH();
			RETURN_BOOL(obj->isNull());
	}
}

//PHP_QT_DESTRUCT(QString);
 
} // extern "C"
