//Auto-generated by kalyptus. DO NOT EDIT.
namespace Akonadi {
    using Kimono;
    using System;
    using Qyoto;
    /// <remarks>
    ///  Serializer plugins convert between the payload of Akonadi.Item objects and
    ///  a textual or binary representation of the actual content data.
    ///  This allows to easily add support for new types to Akonadi.
    ///  The following example shows how to implement a serializer plugin for
    ///  a new data type PimNote.
    ///  The PimNote data structure:
    ///  @code
    ///  typedef struct {
    ///    string author;
    ///    QDateTime dateTime;
    ///    string text;
    ///  } PimNote;
    ///  @endcode
    ///  The serializer plugin code:
    ///  @code
    ///  #include <QtCore/qplugin.h>
    ///  class SerializerPluginPimNote : public QObject, public Akonadi.ItemSerializerPlugin
    ///  {
    ///       Q_INTERFACES( Akonadi.ItemSerializerPlugin )
    ///    public      bool deserialize( Akonadi.Item& item, QByteArray label, QIODevice& data, int version )
    ///      {
    ///        // we don't handle versions in this example
    ///        Q_UNUSED( version );
    ///        // we work only on full payload
    ///        if ( label != Akonadi.Item.FullPayload )
    ///          return false;
    ///        QDataStream stream( &data );
    ///        PimNote note;
    ///        stream >> note.author;
    ///        stream >> note.dateTime;
    ///        stream >> note.text;
    ///        item.setPayload<PimNote>( note );
    ///        return true;
    ///      }
    ///      void serialize( const Akonadi.Item& item, QByteArray label, QIODevice& data, int &version )
    ///      {
    ///        // we don't handle versions in this example
    ///        Q_UNUSED( version );
    ///        if ( label != Akonadi.Item.FullPayload || !item.hasPayload<PimNote>() )
    ///          return;
    ///        QDataStream stream( &data );
    ///        PimNote note = item.payload<PimNote>();
    ///        stream << note.author;
    ///        stream << note.dateTime;
    ///        stream << note.text;
    ///      }
    ///  }
    ///  Q_EXPORT_PLUGIN2( akonadi_serializer_pimnote, SerializerPluginPimNote )
    ///  @endcode
    ///  The desktop file:
    ///  @code
    ///  [Misc]
    ///  Name=Pim Note Serializer
    ///  Comment=An Akonadi serializer plugin for note objects
    ///  [Plugin]
    ///  Type=application/x-pimnote
    ///  X-KDE-Library=akonadi_serializer_pimnote
    ///  @endcode
    /// </remarks>        <author> Till Adam <adam@kde.org>, Volker Krause <vkrause@kde.org>
    ///  </author>
    ///         <short> The base class for item type serializer plugins. </short>
    [SmokeClass("Akonadi::ItemSerializerPlugin")]
    public abstract class ItemSerializerPlugin : Object {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected ItemSerializerPlugin(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(ItemSerializerPlugin), this);
        }
        // QSet<QByteArray> parts(const Akonadi::Item& arg1); >>>> NOT CONVERTED
        /// <remarks>
        ///  Converts serialized item data provided in <code>data</code> into payload for <code>item.</code>
        /// <param> name="item" The item to which the payload should be added.
        ///              It is guaranteed to have a mime type matching one of the supported
        ///              mime types of this plugin.
        ///              However it might contain a unsuited payload added manually
        ///              by the application developer.
        ///              Verifying the payload type in case a payload is already available
        ///              is recommended therefore.
        /// </param><param> name="label" The part identifier of the part to deserialize.
        ///               <code>label</code> might be an unsupported item part, return <code>false</code> if this is the case.
        /// </param><param> name="data" A QIODevice providing access to the serialized data.
        ///              The QIODevice is opened in read-only mode and positioned at the beginning.
        ///              The QIODevice is guaranteed to be valid.
        /// </param><param> name="version" The version of the data format as set by the user in serialize() or <code>0</code> (default).
        /// </param></remarks>        <return> @c false if the specified part is not supported by this plugin, @c true if the part
        ///             could be de-serialized successfully.
        ///      </return>
        ///         <short>    Converts serialized item data provided in <code>data</code> into payload for <code>item.</code></short>
        [SmokeMethod("deserialize(Akonadi::Item&, const QByteArray&, QIODevice&, int)")]
        public abstract bool Deserialize(Akonadi.Item item, QByteArray label, QIODevice data, int version);
        /// <remarks>
        ///  Convert the payload object provided in <code>item</code> into its serialzed form into <code>data.</code>
        /// <param> name="item" The item which contains the payload.
        ///              It is guaranteed to have a mimetype matching one of the supported
        ///              mimetypes of this plugin as well as the existence of a payload object.
        ///              However it might contain an unsupported payload added manually by
        ///              the application developer.
        ///              Verifying the payload type is recommended therefore.
        /// </param><param> name="label" The part identifier of the part to serialize.
        ///               <code>label</code> will be one of the item parts returned by parts().
        /// </param><param> name="data" The QIODevice where the serialized data should be written to.
        ///              The QIODevice is opened in write-only mode and positioned at the beginning.
        ///              The QIODevice is guaranteed to be valid.
        /// </param><param> name="version" The version of the data format. Can be set by the user to handle different
        ///                 versions.
        ///      </param></remarks>        <short>    Convert the payload object provided in <code>item</code> into its serialzed form into <code>data.</code></short>
        [SmokeMethod("serialize(const Akonadi::Item&, const QByteArray&, QIODevice&, int&)")]
        public abstract void Serialize(Akonadi.Item item, QByteArray label, QIODevice data, ref int version);
        /// <remarks>
        ///  Returns a list of available parts for the given item payload.
        ///  The default implementation returns Item.FullPayload if a payload is set.
        /// <param> name="item" The item.
        ///      </param></remarks>        <short>    Returns a list of available parts for the given item payload.</short>
        public ItemSerializerPlugin() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("ItemSerializerPlugin", "ItemSerializerPlugin()", typeof(void));
        }
    }
}
