/*
    yahoobuddyiconloader.h - Fetches YahooBuddyIcons

    Copyright (c) 2005 by Andr Duffeck <andre@duffeck.de>

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef YAHOOBUDDYICONLOADER_
#define	YAHOOBUDDYICONLOADER_

// QT Includes
#include <qobject.h>
#include <qstring.h>
#include <qmap.h>

// KDE Includes
#include <kurl.h>

class KTempFile;
namespace KIO {
	class Job;
	class TransferJob;
}

struct IconLoadJob {
	KURL url;
	QString who;
	int checksum;
	KTempFile *file;
};

/**
 * @author Andr Duffeck
 *
 * This class handles the download of a Buddy icon.
 * If the download was succesfull it emits a signal with a pointer
 * to the temporary file, the icon was stored at
 */
class YahooBuddyIconLoader : public QObject
{
	Q_OBJECT
public:
	YahooBuddyIconLoader();
	~YahooBuddyIconLoader();

	/**
	 *	Add a BuddyIcon for download.
	 */
	void fetchBuddyIcon( const QString &who, KURL url, int checksum );

signals:
	/**
	 * 	The account can connect to this signal and append the icon
	 * 	stored in 'file' to the apropriate contact
	 */
		void fetchedBuddyIcon( const QString &who, KTempFile *file, int checksum );

private slots:
		void slotData( KIO::Job *job, const QByteArray &data );
		void slotComplete( KIO::Job *job );

private:
		typedef QMap< KIO::TransferJob *, IconLoadJob > TransferJobMap;
		TransferJobMap m_jobs;
};

#endif
