package org.kde.koala;
import org.kde.qt.*;


/** Override these methods in subclasses of {@link MainWindow} to customise event handling behaviour */
public interface MainWindowEventHandling {
	void keyPressEvent(QKeyEvent arg1);
	void keyReleaseEvent(QKeyEvent arg1);
	void focusOutEvent(QFocusEvent arg1);
	void childEvent(QChildEvent e);
	void dragMoveEvent(QDragMoveEvent arg1);
	void leaveEvent(QEvent arg1);
	void showEvent(QShowEvent arg1);
	void mousePressEvent(QMouseEvent arg1);
	void customEvent(QCustomEvent arg1);
	void mouseReleaseEvent(QMouseEvent arg1);
	void mouseDoubleClickEvent(QMouseEvent arg1);
	void dragLeaveEvent(QDragLeaveEvent arg1);
	void enterEvent(QEvent arg1);
	void focusInEvent(QFocusEvent arg1);
	void dropEvent(QDropEvent arg1);
	void dragEnterEvent(QDragEnterEvent arg1);
	void mouseMoveEvent(QMouseEvent arg1);
	void moveEvent(QMoveEvent arg1);
	void wheelEvent(QWheelEvent arg1);
	void hideEvent(QHideEvent arg1);

/** 
 Reimplemented to call the queryClose() and queryExit() handlers.

 We recommend that you reimplement the handlers rather than {@link MainWindow#closeEvent}.
 If you do it anyway, ensure to call the base implementation to keep
 {@link MainWindow#queryExit} running.
     
*/
	void closeEvent(QCloseEvent arg1);
	void paintEvent(QPaintEvent e);
	void timerEvent(QTimerEvent arg1);
	void resizeEvent(QResizeEvent e);
}

