/***************************************************************************
                            KSelectAction.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

  Action for selecting one of several items.

  This action shows up a submenu with a list of items.
  One of them can be checked. If the user clicks on an item
  this item will automatically be checked,
  the formerly checked item becomes unchecked.
  There can be only one item checked at a time.

 See {@link KSelectActionSignals} for signals emitted by KSelectAction.

 See {@link KSelectActionEventHandling} for event handlers to override in subclasses of KSelectAction.

 @short Action for selecting one of several items.
*/
public class KSelectAction extends KAction  {
	protected KSelectAction(Class dummy){super((Class) null);}


/** 
 Construct a select action with text and potential keyboard
 accelerator but nothing else. Use this only if you really
 know what you are doing.

*/
	private native void newKSelectAction( String text, int accel, QObject parent, String name);
	public KSelectAction( String text, int accel, QObject parent, String name) {
		super((Class) null);
		newKSelectAction( text, accel, parent, name);
	}
	private native void newKSelectAction( String text);
	public KSelectAction( String text) {
		super((Class) null);
		newKSelectAction( text);
	}

/** 

*/
	private native void newKSelectAction( String text, int accel, QObject receiver, String slot, QObject parent, String name);
	public KSelectAction( String text, int accel, QObject receiver, String slot, QObject parent, String name) {
		super((Class) null);
		newKSelectAction( text, accel, receiver, slot, parent, name);
	}
	private native void newKSelectAction( String text, int accel, QObject receiver, String slot, QObject parent);
	public KSelectAction( String text, int accel, QObject receiver, String slot, QObject parent) {
		super((Class) null);
		newKSelectAction( text, accel, receiver, slot, parent);
	}

/** 

*/
	private native void newKSelectAction( String text, QIconSet pix, int accel, QObject parent, String name);
	public KSelectAction( String text, QIconSet pix, int accel, QObject parent, String name) {
		super((Class) null);
		newKSelectAction( text, pix, accel, parent, name);
	}
	private native void newKSelectAction( String text, QIconSet pix);
	public KSelectAction( String text, QIconSet pix) {
		super((Class) null);
		newKSelectAction( text, pix);
	}

/** 

*/
	private native void newKSelectAction( String text, String pix, int accel, QObject parent, String name);
	public KSelectAction( String text, String pix, int accel, QObject parent, String name) {
		super((Class) null);
		newKSelectAction( text, pix, accel, parent, name);
	}
	private native void newKSelectAction( String text, String pix);
	public KSelectAction( String text, String pix) {
		super((Class) null);
		newKSelectAction( text, pix);
	}

/** 

*/
	private native void newKSelectAction( String text, QIconSet pix, int accel, QObject receiver, String slot, QObject parent, String name);
	public KSelectAction( String text, QIconSet pix, int accel, QObject receiver, String slot, QObject parent, String name) {
		super((Class) null);
		newKSelectAction( text, pix, accel, receiver, slot, parent, name);
	}
	private native void newKSelectAction( String text, QIconSet pix, int accel, QObject receiver, String slot, QObject parent);
	public KSelectAction( String text, QIconSet pix, int accel, QObject receiver, String slot, QObject parent) {
		super((Class) null);
		newKSelectAction( text, pix, accel, receiver, slot, parent);
	}

/** 

*/
	private native void newKSelectAction( String text, String pix, int accel, QObject receiver, String slot, QObject parent, String name);
	public KSelectAction( String text, String pix, int accel, QObject receiver, String slot, QObject parent, String name) {
		super((Class) null);
		newKSelectAction( text, pix, accel, receiver, slot, parent, name);
	}
	private native void newKSelectAction( String text, String pix, int accel, QObject receiver, String slot, QObject parent);
	public KSelectAction( String text, String pix, int accel, QObject receiver, String slot, QObject parent) {
		super((Class) null);
		newKSelectAction( text, pix, accel, receiver, slot, parent);
	}

/** 

*/
	private native void newKSelectAction( QObject parent, String name);
	public KSelectAction( QObject parent, String name) {
		super((Class) null);
		newKSelectAction( parent, name);
	}
	private native void newKSelectAction();
	public KSelectAction() {
		super((Class) null);
		newKSelectAction();
	}

/** 
 Destructor
     
*/
	protected native void finalize() throws InternalError;

/** 
  "Plug" or insert this action into a given widget.

  This will typically be a menu or a toolbar.
  From this point on, you will never need to directly
  manipulate the item in the menu or toolbar.
  You do all enabling/disabling/manipulation directly with your KSelectAction object.

*/
	public native int plug( QWidget widget, int index);
	public native int plug( QWidget widget);

/** 
 When this action is plugged into a toolbar, it creates a combobox.

*/
	public native boolean isEditable();

/** 

*/
	public native ArrayList items();
	public native void changeItem( int index, String text);
	public native String currentText();
	public native int currentItem();

/** 
 When this action is plugged into a toolbar, it creates a combobox.
 This returns the maximum width set by setComboWidth
     
*/
	public native int comboWidth();
	public native QPopupMenu popupMenu();

/** 
  Sets the currently checked item.

*/
	public native void setCurrentItem( int index);

/** 
 Sets the items to be displayed in this action
 You need to call this.
     
*/
	public native void setItems( String[] lst);

/** 
 Clears up all the items in this action
     
*/
	public native void clear();

/** 
 When this action is plugged into a toolbar, it creates a combobox.
 This makes the combo editable or read-only.
     
*/
	public native void setEditable( boolean arg1);

/** 
 When this action is plugged into a toolbar, it creates a combobox.
 This gives a _maximum_ size to the combobox.
 The minimum size is automatically given by the contents (the items).
     
*/
	public native void setComboWidth( int width);
	protected native void changeItem( int identifier, int index, String text);
	protected native void setCurrentItem( int identifier, int index);
	protected native void setComboWidth( int identifier, int width);
	protected native void setItems( int identifier, String[] lst);
	protected native void clear( int identifier);
	protected native void slotActivated( int identifier);
	protected native void slotActivated( String text);
	protected native void slotActivated();
}
