/***************************************************************************
                            KPanelExtension.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Implement a panel extension.

 Panel extensions

 Note: For security and stability reasons the panel won't load
 untrusted third party extensions directly into its namespace but via an
 external wrapper process.

 The panel locates available extensions by searching for extension desktop
 files in (ALL_KDEDIRS)/share/apps/kicker/extensions. Every panel extension should
 install a desktop file there to be recognised by the panel.

 Besides standard keys like "Name", "Comment" and "Icon" there are
 two panel extension specific keys:

 Used by the panel to locate the extension DSO (Dynamic Shared Object)
 Example: X-KDE-Library=libexampleextension

 Similar to {@link KApplication} and {@link KUniqueApplication} there are
 two types of panel extensions. Use unique extensions when it makes no
 sence to run more than one instance of an extension in the panel. A
 good example for unique extensions is the taskbar extension.  Use normal
 extensions when you need instance specific configuration. An example
 is a subpanel extension where you might want to run more than one instances.
 X-KDE-UniqueExtension is a boolean key which defaults
 to "false".  Example: X-KDE-UniqueExtension=true

 Back to panel extension DSOs, the following conventions are used for KDE:
 Name:    lib<extensionname>extension.la
 LDFLAGS: -module -no-undefined

 To implement a panel extension it is not enough to write a class
 inheriting from {@link KPanelExtension} but you also have to provide a
 factory function in your DSO.  A sample factory function could look
 like this:

 <pre>

 extern "C"
 {
     KPanelExtension init(QWidget parent, String configFile)
     {
         KGlobal.locale().insertCatalogue("exampleextension");
         return new ExampleExtension(configFile, KPanelExtension.Normal,
                       KPanelExtension.About | KPanelExtension.Help | KPanelExtension.Preferences,
                       parent, "exampleextension");
     }
 }

 </pre>

 Note: Don't change the factory function signature or the panel will
 fail to load your extension.

 See {@link KPanelExtensionSignals} for signals emitted by KPanelExtension.

 See {@link KPanelExtensionEventHandling} for event handlers to override in subclasses of KPanelExtension.

 @author Matthias Elter <elter@kde.org>

 @short KDE Panel Extension class.
*/
public class KPanelExtension extends QFrame  {
	protected KPanelExtension(Class dummy){super((Class) null);}


/** 
 Construct a {@link KPanelExtension} just like any other widget.

*/
	private native void newKPanelExtension( String configFile, int t, int actions, QWidget parent, String name);
	public KPanelExtension( String configFile, int t, int actions, QWidget parent, String name) {
		super((Class) null);
		newKPanelExtension( configFile, t, actions, parent, name);
	}
	private native void newKPanelExtension( String configFile);
	public KPanelExtension( String configFile) {
		super((Class) null);
		newKPanelExtension( configFile);
	}

/** 
 Destructor.

*/
	protected native void finalize() throws InternalError;

/** 
 Retrieve a prefered size for a given Position.

 Every extension should reimplement this function.

 Depending on the panel position the extensions can choose a prefered size for that
 location in the Window Manager Dock. Please note that the size can not be larger than the
 maxsize given by the handler.

*/
	public native QSize sizeHint( int arg1, QSize maxsize);

/** 
 Always use this {@link KConfig} object to save/load your extensions configuration.

 For unique extensions this config object will write to a config file called
 <extensionname>rc in the users local KDE directory.

 For normal extensions this config object will write to a instance specific config file
 called <extensionname><instanceid>rc in the users local KDE directory.

*/
	public native KConfig config();

/** 

*/
	public native int type();

/** 

*/
	public native int actions();

/** 
 Generic action dispatcher. Called  when the user selects an item
 from the extensions RMB menu.

 Reimplement this function to handle actions.

 For About, Help and Preferences, use the convenience handlers
 ref about(), help(), preferences()

*/
	public native void action( int a);

/** 
 Reimplement this function to set a prefered dock position for your extension.
 The extension manager will try to place new instances of this extension according
 to this setting.

*/
	public native int preferedPosition();

/** 
 Don't reimplement, this is used internally

*/
	public native void slotSetPosition( int p);

/** 
 Is called when the user selects "About" from the extensions RMB menu.
 Reimplement this function to launch a about dialog.

 Note that this is called only when your extension supports the About action.
 See {@link Action} and {@link #KPanelExtension}.

*/
	protected native void about();

/** 
 Is called when the user selects "Help" from the extensions RMB menu.
 Reimplement this function to launch a manual or help page.

 Note that this is called only when your extension supports the Help action.
 See {@link Action} and {@link #KPanelExtension}.

*/
	protected native void help();

/** 
 Is called when the user selects "Preferences" from the extensions RMB menu.
 Reimplement this function to launch a preferences dialog or kcontrol module.

 Note that this is called only when your extension supports the preferences action.
 See {@link Action} and {@link #KPanelExtension}.

*/
	protected native void preferences();

/** 

*/
	protected native int position();

/** 

*/
	protected native int orientation();

/** 
 The position changed to <code>position.</code> Reimplement this
 change handler in order to adjust the look of your extension.

*/
	protected native void positionChange( int arg1);
	public static final int Normal = 0;
	public static final int Stretch = 0;
	public static final int About = 1;
	public static final int Help = 2;
	public static final int Preferences = 4;
	public static final int ReportBug = 8;
	public static final int Left = 0;
	public static final int Right = 0;
	public static final int Top = 1;
	public static final int Bottom = 2;
}
