/***************************************************************************
                            KEditToolbar.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This is a dialog used to customize or configure toolbars

 This dialog only works if your application uses the XML UI
 framework for creating menus and toolbars.  It depends on the XML
 files to describe the toolbar layouts and it requires the actions
 to determine which buttons are active.

 Typically, you would include the {@link KStdAction#configureToolbars}
 standard action in your application.  In your slot to this action,
 you would have something like so:

 <pre>
 KEditToolbar dlg(actionCollection());
 if (dlg.exec())
 {
   createGUI();
 }
 </pre>

 That code snippet also takes care of redrawing the menu and
 toolbars if you have made any changes.

 If you are using KMainWindow's settings methods (either save/apply manually
 or autoSaveSettings), you should write something like:
 <pre>
 void MyClass.slotConfigureToolbars()
 {
   saveMainWindowSettings( KGlobal.config(), "MainWindow" );
   KEditToolbar dlg(actionCollection());
   connect(&dlg,SIGNAL("newToolbarConfig()"),this,SLOT("slotNewToolbarConfig()"));
   if (dlg.exec())
   {
      createGUI();
   }
 }

 void MyClass.slotNewToolbarConfig() // This is called when OK or Apply is clicked
 {
    ...if you use any action list, use plugActionList on each here...
    applyMainWindowSettings( KGlobal.config(), "MainWindow" );
 }
 </pre>

 Note that the procedure is a bit different for {@link KParts} applications.
 In this case, you need only pass along a pointer to your
 application's {@link KXMLGUIFactory} object.  The editor will take care of
 finding all of the action collections and xml files.  The editor
 aims to be semi-intelligent about where it assigns any
 modifications.  In other words, it will not write out part specific
 changes to your shell's xml file.

 An example would be:

 <pre>
 saveMainWindowSettings( KGlobal.config(), "MainWindow" );
 KEditToolbar dlg(factory());
 connect(&dlg,SIGNAL("newToolbarConfig()"),this,SLOT("slotNewToolbarConfig()"));
 dlg.exec(); // Note that you shouldn't call createGUI(), so if() might not be even needed anymore

 ... // See above for slotNewToolbarConfig
 </pre>

 See {@link KEditToolbarSignals} for signals emitted by KEditToolbar.

 See {@link KEditToolbarEventHandling} for event handlers to override in subclasses of KEditToolbar.

 @author Kurt Granroth <granroth@kde.org>

 @short A dialog used to customize or configure toolbars.

*/
public class KEditToolbar extends KDialogBase  {
	protected KEditToolbar(Class dummy){super((Class) null);}


/** 
 Constructor for apps that do not use components.

 This is the
 only entry point to this class.  You <em>must</em> pass along your
 collection of actions (some of which appear in your toolbars).
 The other two parameters are optional.

 The second parameter, {@link #xmlfile}, is the name (absolute or
 relative) of your application's UI resource file.  If it is
 left blank, then the resource file: share/apps/appname/appnameui.rc
 is used.  This is the same resource file that is used by the
 default {@link #createGUI} function in {@link KMainWindow} so you're usually
 pretty safe in leaving it blank.

 The third parameter, {@link #global}, controls whether or not the
 global resource file is used.  If this is <code>true</code>, then you may
 edit all of the actions in your toolbars -- global ones and
 local one.  If it is <code>false</code>, then you may edit only your
 application's entries.  The only time you should set this to
 false is if your application does not use the global resource
 file at all (very rare).

*/
	private native void newKEditToolbar( KActionCollection collection, String xmlfile, boolean global, QWidget parent, String name);
	public KEditToolbar( KActionCollection collection, String xmlfile, boolean global, QWidget parent, String name) {
		super((Class) null);
		newKEditToolbar( collection, xmlfile, global, parent, name);
	}
	private native void newKEditToolbar( KActionCollection collection);
	public KEditToolbar( KActionCollection collection) {
		super((Class) null);
		newKEditToolbar( collection);
	}

/** 
 Constructor for {@link KParts} based apps.

 The main parameter, {@link #factory}, is a pointer to the
 XML GUI factory object for your application.  It contains a list
 of all of the GUI clients (along with the action collections and
 xml files) and the toolbar editor uses that.

 Use this like so:
 <pre>
 KEditToolbar edit(factory());
 if ( edit.exec() )
 ...
 </pre>

*/
	private native void newKEditToolbar( KXMLGUIFactory factory, QWidget parent, String name);
	public KEditToolbar( KXMLGUIFactory factory, QWidget parent, String name) {
		super((Class) null);
		newKEditToolbar( factory, parent, name);
	}
	private native void newKEditToolbar( KXMLGUIFactory factory);
	public KEditToolbar( KXMLGUIFactory factory) {
		super((Class) null);
		newKEditToolbar( factory);
	}
	protected native void finalize() throws InternalError;

/** 
 Overridden in order to save any changes made to the toolbars
   
*/
	protected native void slotOk();

/** 
 idem
   
*/
	protected native void slotApply();

/**  should OK really save?

*/
	protected native void acceptOK( boolean b);
}
