package org.kde.koala;
import org.kde.qt.*;


/** {@link KDirOperator} emits these signals */
public interface KDirOperatorSignals {
	void updateInformation( int files, int dirs );
	void destroyed();
	void fileHighlighted( KFileViewItem arg1 );
	void urlEntered( KURL arg1 );
	void finishedLoading();

/** 
 Emitted whenever the current fileview is changed, either by an explicit
 call to {@link KDirOperator#setView} or by the user selecting a different view thru
 the GUI.
     
*/
	void viewChanged( KFileViewInterface newView );
	void dirActivated( KFileViewItem arg1 );
	void completion( String arg1 );
	void fileSelected( KFileViewItem arg1 );
}

