/***************************************************************************
                            HTMLSelectElement.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 The select element allows the selection of an option. The contained
 options can be directly accessed through the select element as a
 collection. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#edef-SELECT">
 SELECT element definition </a> in HTML 4.0.

 
 @short 
 The select element allows the selection of an option.
*/
public class HTMLSelectElement extends HTMLElement  {
	protected HTMLSelectElement(Class dummy){super((Class) null);}

	private native void newHTMLSelectElement();
	public HTMLSelectElement() {
		super((Class) null);
		newHTMLSelectElement();
	}
	private native void newHTMLSelectElement( HTMLSelectElement other);
	public HTMLSelectElement( HTMLSelectElement other) {
		super((Class) null);
		newHTMLSelectElement( other);
	}
	private native void newHTMLSelectElement( DOMNode other);
	public HTMLSelectElement( DOMNode other) {
		super((Class) null);
		newHTMLSelectElement( other);
	}
	protected native void finalize() throws InternalError;

/** 
 The type of control created.

     
*/
	public native String type();

/** 
 The ordinal index of the selected option. The value -1 is
 returned if no element is selected. If multiple options are
 selected, the index of the first selected option is returned.

     
*/
	public native long selectedIndex();

/** 
 see {@link selectedIndex}
     
*/
	public native void setSelectedIndex( long arg1);

/** 
 The current form control value.

     
*/
	public native String value();

/** 
 see {@link value}
     
*/
	public native void setValue( String arg1);

/** 
 The number of options in this <code> SELECT </code> .

     
*/
	public native long length();

/** 
 Returns the <code> FORM </code> element containing this
 control. Returns null if this control is not within the context
 of a form.

     
*/
	public native HTMLFormElement form();

/** 
 The collection of <code> OPTION </code> elements contained by
 this element.

     
*/
	public native HTMLCollection options();

/** 
 The control is unavailable in this context. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-disabled">
 disabled attribute definition </a> in HTML 4.0.

     
*/
	public native boolean disabled();

/** 
 see {@link disabled}
     
*/
	public native void setDisabled( boolean arg1);

/** 
 If true, multiple <code> OPTION </code> elements may be
 selected in this <code> SELECT </code> . See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-multiple">
 multiple attribute definition </a> in HTML 4.0.

     
*/
	public native boolean multiple();

/** 
 see {@link multiple}
     
*/
	public native void setMultiple( boolean arg1);

/** 
 Form control or object name when submitted with a form. See the
 <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-name-SELECT">
 name attribute definition </a> in HTML 4.0.

     
*/
	public native String name();

/** 
 see {@link name}
     
*/
	public native void setName( String arg1);

/** 
 Number of visible rows. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-size-SELECT">
 size attribute definition </a> in HTML 4.0.

     
*/
	public native long size();

/** 
 see {@link size}
     
*/
	public native void setSize( long arg1);

/** 
 Index that represents the element's position in the tabbing
 order. See the <a
 href="http://www.w3.org/TR/REC-html40/interact/forms.html#adef-tabindex">
 tabindex attribute definition </a> in HTML 4.0.

     
*/
	public native long tabIndex();

/** 
 see {@link tabIndex}
     
*/
	public native void setTabIndex( long arg1);

/** 
 Add a new element to the collection of <code> OPTION </code>
 elements for this <code> SELECT </code> .

     
*/
	public native void add( HTMLElement element, HTMLElement before);

/** 
 Remove an element from the collection of <code> OPTION </code>
 elements for this <code> SELECT </code> . Does nothing if no
 element has the given index.

     
*/
	public native void remove( long index);

/** 
 Removes keyboard focus from this element.

     
*/
	public native void blur();

/** 
 Gives keyboard focus to this element.

     
*/
	public native void focus();
//	private native void newHTMLSelectElement( HTMLSelectElementImpl impl);
//	public HTMLSelectElement( HTMLSelectElementImpl impl) {
//		super((Class) null);
//		newHTMLSelectElement( impl);
//	}
}
