/***************************************************************************
                            DocumentType.java -  description
                             -------------------
    begin                : Sun Aug 26 09:45:02 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Aug 26 09:45:02 2001, using kdoc parser/custom Java conversion backend.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Each <code> Document </code> has a <code> doctype </code> attribute
 whose value is either <code> null </code> or a <code> DocumentType
 </code> object. The <code> DocumentType </code> interface in the
 DOM Level 1 Core provides an interface to the list of entities that
 are defined for the document, and little else because the effect of
 namespaces and the various XML scheme efforts on DTD representation
 are not clearly understood as of this writing.

  The DOM Level 1 doesn't support editing <code> DocumentType
 </code> nodes.

 
 @short 
 Each <code> Document </code> has a <code> doctype </code> attribute
 whose value is either <code> null </code> or a <code> DocumentType
 </code> object.
*/
public class DocumentType extends DOMNode  {
	protected DocumentType(Class dummy){super((Class) null);}

	private native void newDocumentType();
	public DocumentType() {
		super((Class) null);
		newDocumentType();
	}
	private native void newDocumentType( DocumentType other);
	public DocumentType( DocumentType other) {
		super((Class) null);
		newDocumentType( other);
	}
	private native void newDocumentType( DOMNode other);
	public DocumentType( DOMNode other) {
		super((Class) null);
		newDocumentType( other);
	}
	protected native void finalize() throws InternalError;

/** 
 The name of DTD; i.e., the name immediately following the
 <code> DOCTYPE </code> keyword.

     
*/
	public native String name();

/** 
 A <code> NamedNodeMap </code> containing the general entities,
 both external and internal, declared in the DTD. Duplicates are
 discarded. For example in: &lt;!DOCTYPE ex SYSTEM "ex.dtd" [
 &lt;!ENTITY foo "foo"> &lt;!ENTITY bar "bar"> &lt;!ENTITY % baz
 "baz"> ]> &lt;ex/> the interface provides access to <code> foo
 </code> and <code> bar </code> but not <code> baz </code> .
 Every node in this map also implements the <code> Entity
 </code> interface.

  The DOM Level 1 does not support editing entities, therefore
 <code> entities </code> cannot be altered in any way.

     
*/
	public native NamedNodeMap entities();

/** 
 A <code> NamedNodeMap </code> containing the notations declared
 in the DTD. Duplicates are discarded. Every node in this map
 also implements the <code> Notation </code> interface.

  The DOM Level 1 does not support editing notations, therefore
 <code> notations </code> cannot be altered in any way.

     
*/
	public native NamedNodeMap notations();
//	private native void newDocumentType( DocumentTypeImpl* impl);
//	public DocumentType( DocumentTypeImpl* impl) {
//		super((Class) null);
//		newDocumentType( impl);
//	}
}
