; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -instsimplify -S | FileCheck %s

; X == 42.0 ? X : 42.0 --> 42.0

define double @oeq(double %x) {
; CHECK-LABEL: @oeq(
; CHECK-NEXT:    ret double 4.200000e+01
;
  %cmp = fcmp oeq double %x, 42.0
  %cond = select i1 %cmp, double %x, double 42.0
  ret double %cond
}

; X == 42.0 ? 42.0 : X --> X

define float @oeq_swapped(float %x) {
; CHECK-LABEL: @oeq_swapped(
; CHECK-NEXT:    ret float [[X:%.*]]
;
  %cmp = fcmp oeq float %x, 42.0
  %cond = select i1 %cmp, float 42.0, float %x
  ret float %cond
}

; x != y ? x : y -> x if it's the right kind of != and at least
; one of x and y is not negative zero.

; X != 42.0 ? X : 42.0 --> X

define double @une(double %x) {
; CHECK-LABEL: @une(
; CHECK-NEXT:    ret double [[X:%.*]]
;
  %cmp = fcmp une double %x, 42.0
  %cond = select i1 %cmp, double %x, double 42.0
  ret double %cond
}

; X != 42.0 ? 42.0 : X --> 42.0

define double @une_swapped(double %x) {
; CHECK-LABEL: @une_swapped(
; CHECK-NEXT:    ret double 4.200000e+01
;
  %cmp = fcmp une double %x, 42.0
  %cond = select i1 %cmp, double 42.0, double %x
  ret double %cond
}

define double @une_could_be_negzero(double %x, double %y) {
; CHECK-LABEL: @une_could_be_negzero(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp une double [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], double [[X]], double [[Y]]
; CHECK-NEXT:    ret double [[COND]]
;
  %cmp = fcmp une double %x, %y
  %cond = select i1 %cmp, double %x, double %y
  ret double %cond
}

define double @une_swapped_could_be_negzero(double %x, double %y) {
; CHECK-LABEL: @une_swapped_could_be_negzero(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp une double [[X:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], double [[Y]], double [[X]]
; CHECK-NEXT:    ret double [[COND]]
;
  %cmp = fcmp une double %x, %y
  %cond = select i1 %cmp, double %y, double %x
  ret double %cond
}

define double @one(double %x) {
; CHECK-LABEL: @one(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one double [[X:%.*]], -1.000000e+00
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], double [[X]], double -1.000000e+00
; CHECK-NEXT:    ret double [[COND]]
;
  %cmp = fcmp one double %x, -1.0
  %cond = select i1 %cmp, double %x, double -1.0
  ret double %cond
}

define double @one_swapped(double %x) {
; CHECK-LABEL: @one_swapped(
; CHECK-NEXT:    [[CMP:%.*]] = fcmp one double [[X:%.*]], -1.000000e+00
; CHECK-NEXT:    [[COND:%.*]] = select i1 [[CMP]], double -1.000000e+00, double [[X]]
; CHECK-NEXT:    ret double [[COND]]
;
  %cmp = fcmp one double %x, -1.0
  %cond = select i1 %cmp, double -1.0, double %x
  ret double %cond
}

