#!/bin/ksh ~/.mgltools/pythonsh
########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Thursday 30 July 2009 16:19:23 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Tutorial/cartoon/cartoon4_net.py,v 1.5 2009/07/31 00:54:52 vareille Exp $
#
# $Id: cartoon4_net.py,v 1.5 2009/07/31 00:54:52 vareille Exp $
#


if __name__=='__main__':
    from sys import argv
    if '--help' in argv or '-h' in argv or '-w' in argv: # run without Vision
        withoutVision = True
        from Vision.VPE import NoGuiExec
        ed = NoGuiExec()
        from NetworkEditor.net import Network
        import os
        masterNet = Network("process-"+str(os.getpid()))
        ed.addNetwork(masterNet)
    else: # run as a stand alone application while vision is hidden
        withoutVision = False
        from Vision import launchVisionToRunNetworkAsApplication, mainLoopVisionToRunNetworkAsApplication
	if '-noSplash' in argv:
	    splash = False
	else:
	    splash = True
        masterNet = launchVisionToRunNetworkAsApplication(splash=splash)
        import os
        masterNet.filename = os.path.abspath(__file__)
from traceback import print_exc
## loading libraries ##
from Vision.PILNodes import imagelib
from Vision.StandardNodes import stdlib
try:
    masterNet
except (NameError, AttributeError): # we run the network outside Vision
    from NetworkEditor.net import Network
    masterNet = Network()

masterNet.getEditor().addLibraryInstance(imagelib,"Vision.PILNodes", "imagelib")

masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node Read Image ##
    from Vision.PILNodes import ReadImage
    Read_Image_1 = ReadImage(constrkw={}, name='Read Image', library=imagelib)
    masterNet.addNode(Read_Image_1,11,202)
    apply(Read_Image_1.inputPortByName['filename'].configure, (), {'datatype': 'string', 'originalDatatype': 'str'})
    Read_Image_1.inputPortByName['filename'].rebindWidget()
    Read_Image_1.inputPortByName['filename'].widget.set(r"", run=False)
    Read_Image_1.inputPortByName['filename'].unbindWidget()
    apply(Read_Image_1.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ReadImage named Read Image in network masterNet"
    print_exc()
    Read_Image_1=None

try:
    ## saving node Scale ##
    from Vision.PILNodes import ResizeImage
    Scale_2 = ResizeImage(constrkw={}, name='Scale', library=imagelib)
    masterNet.addNode(Scale_2,11,251)
    apply(Scale_2.inputPortByName['scale'].widget.configure, (), {'widgetGridCfgMyApp': {'column': 0, 'labelSide': 'top', 'row': 2}})
    Scale_2.inputPortByName['scale'].widget.set(0.753788687588, run=False)
    Scale_2.inputPortByName['filter'].widget.set(r"NEAREST", run=False)
    apply(Scale_2.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore ResizeImage named Scale in network masterNet"
    print_exc()
    Scale_2=None

try:
    ## saving node Show Image ##
    from Vision.PILNodes import ShowImage
    Show_Image_3 = ShowImage(constrkw={}, name='Show Image', library=imagelib)
    masterNet.addNode(Show_Image_3,11,359)
    apply(Show_Image_3.configure, (), {'paramPanelImmediate': 1, 'expanded': False})
except:
    print "WARNING: failed to restore ShowImage named Show Image in network masterNet"
    print_exc()
    Show_Image_3=None

try:
    ## saving node call method ##
    from Vision.StandardNodes import CallMethod
    call_method_4 = CallMethod(constrkw={}, name='call method', library=stdlib)
    masterNet.addNode(call_method_4,13,109)
    call_method_4.inputPortByName['signature'].widget.set(r"sort", run=False)
    apply(call_method_4.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore CallMethod named call method in network masterNet"
    print_exc()
    call_method_4=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_5 = Index(constrkw={}, name='Index', library=stdlib)
    masterNet.addNode(Index_5,169,197)
    apply(Index_5.inputPortByName['index'].widget.configure, (), {'max': 100, 'widgetGridCfgMyApp': {'column': 1, 'labelSide': 'left', 'row': 3}, 'min': -101})
    Index_5.inputPortByName['index'].widget.set(0, run=False)
    apply(Index_5.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_5=None

try:
    ## saving node Entry ##
    from Vision.StandardNodes import Filelist
    Entry_6 = Filelist(constrkw={}, name='Entry', library=stdlib)
    masterNet.addNode(Entry_6,13,4)
    Entry_6.inputPortByName['directory'].widget.set(r".", run=False)
    Entry_6.inputPortByName['match_str'].widget.set(r"cartoonMovie/*.png", run=False)
    apply(Entry_6.configure, (), {'paramPanelImmediate': 1})
except:
    print "WARNING: failed to restore Filelist named Entry in network masterNet"
    print_exc()
    Entry_6=None

#masterNet.run()
masterNet.freeze()

## saving connections for network cartoon4 ##
if Read_Image_1 is not None and Scale_2 is not None:
    try:
        masterNet.connectNodes(
            Read_Image_1, Scale_2, "image", "image", blocking=True
            , splitratio=[0.65278536854020563, 0.45689425451156823])
    except:
        print "WARNING: failed to restore connection between Read_Image_1 and Scale_2 in network masterNet"
if Scale_2 is not None and Show_Image_3 is not None:
    try:
        masterNet.connectNodes(
            Scale_2, Show_Image_3, "scaledImage", "image", blocking=True
            , splitratio=[0.32335576554314405, 0.33086601820743644])
    except:
        print "WARNING: failed to restore connection between Scale_2 and Show_Image_3 in network masterNet"
if call_method_4 is not None and Index_5 is not None:
    try:
        masterNet.connectNodes(
            call_method_4, Index_5, "objects", "data", blocking=True
            , splitratio=[0.33130284210394223, 0.28709344894782485])
    except:
        print "WARNING: failed to restore connection between call_method_4 and Index_5 in network masterNet"
if Index_5 is not None and Read_Image_1 is not None:
    try:
        masterNet.connectNodes(
            Index_5, Read_Image_1, "data", "filename", blocking=True
            , splitratio=[0.14905179643421185, -0.18518518518518517])
    except:
        print "WARNING: failed to restore connection between Index_5 and Read_Image_1 in network masterNet"
if Entry_6 is not None and call_method_4 is not None:
    try:
        masterNet.connectNodes(
            Entry_6, call_method_4, "filelist", "objects", blocking=True
            , splitratio=[0.665496483106085, 0.35830303035521827])
    except:
        print "WARNING: failed to restore connection between Entry_6 and call_method_4 in network masterNet"
masterNet.runOnNewData.value = False

if __name__=='__main__':
    from sys import argv
    lNodePortValues = []
    if (len(argv) > 0) and argv[1].startswith('-'):
        lArgIndex = 2
    else:
        lArgIndex = 1
    while lArgIndex < len(argv) and argv[lArgIndex][-3:]!='.py':
        lNodePortValues.append(argv[lArgIndex])
        lArgIndex += 1
    masterNet.setNodePortValues(lNodePortValues)
    if '--help' in argv or '-h' in argv: # show help
        masterNet.helpForNetworkAsApplication()
    elif '-w' in argv: # run without Vision and exit
         # create communicator
        from NetworkEditor.net import Communicator
        masterNet.communicator = Communicator(masterNet)
        print 'Communicator listening on port:', masterNet.communicator.port

        import socket
        f = open(argv[0]+'.sock', 'w')
        f.write("%s %i"%(socket.gethostbyname(socket.gethostname()),
                         masterNet.communicator.port))
        f.close()

        # create communication socket
        import socket
        HOST = ''                 # Symbolic name meaning the local host
        PORT = 50010              # Arbitrary non-privileged port
        s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        s.bind((HOST, PORT))
        s.listen(5)
        s.setblocking(0)
        masterNet.socket = s
        masterNet.socketConnections = []
        masterNet.HOST = HOST
        masterNet.PORT = PORT

        masterNet.run()

    else: # stand alone application while vision is hidden
        if '-e' in argv: # run and exit
            masterNet.run()
        elif '-r' in argv or len(masterNet.userPanels) == 0: # no user panel => run
            masterNet.run()
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)
        else: # user panel
            mainLoopVisionToRunNetworkAsApplication(masterNet.editor)

